/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Record;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopRecord;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.FileNames;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.Path;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.PathContainer;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.PathResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvaluationResult {
    private int totalPaths;
    private String mapName;
    private LogCategory log;
    private HashSet<PathResult> pathResults;
    private int completedCount = 0;
    private int failedCount = 0;
    private int notBuiltCount = 0;
    private int processedCount = 0;
    private int failedToStartCount = 0;
    private int failedInNavigateCount = 0;
    private int failedToStartInNavigateCount = 0;
    private int idx = 0;
    private String resultPath;
    private boolean isInitialized;

    public EvaluationResult(int total, String map, LogCategory log, String resultPath) {
        this.totalPaths = total;
        this.mapName = map;
        this.log = log;
        this.resultPath = resultPath;
        this.pathResults = new HashSet(this.totalPaths);
        this.isInitialized = log != null;
    }

    public void addResult(Path path, PathResult.ResultType type, long duration) {
        this.updateCounters(type);
        this.pathResults.add(new PathResult(path, type, duration));
    }

    public void addResult(Path path, PathResult.ResultType type, long duration, Location location, NavPoint nearestNavPoint) {
        this.updateCounters(type);
        this.pathResults.add(new PathResult(path, type, duration, location, nearestNavPoint));
    }

    private void updateCounters(PathResult.ResultType type) {
        ++this.processedCount;
        switch (type) {
            case Completed: {
                ++this.completedCount;
                break;
            }
            case NotBuilt: {
                ++this.notBuiltCount;
                break;
            }
            case Failed: {
                ++this.failedCount;
                break;
            }
            case FailedToStart: {
                ++this.failedToStartCount;
                break;
            }
            case FailedInNavigate: {
                ++this.failedInNavigateCount;
                break;
            }
            case FailedToStartInNavigate: {
                ++this.failedToStartInNavigateCount;
                break;
            }
            default: {
                throw new AssertionError((Object)type.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAggregate() {
        OutputStreamWriter fstream = null;
        try {
            File resultFile = this.getResultFile("data.aggregate.csv");
            fstream = new FileWriter(resultFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("Map;Total;Processes;Completed;Failed;NotBuilt;FailedToStart;FailedInNavigate;FailedToStartInNavigate");
            out.newLine();
            out.write(String.format("%s;%d;%d;%d;%d;%d;%d;%d;%d", this.mapName, this.totalPaths, this.processedCount, this.completedCount, this.failedCount, this.notBuiltCount, this.failedToStartCount, this.failedInNavigateCount, this.failedToStartInNavigateCount));
            out.newLine();
            out.close();
        }
        catch (IOException ex) {
            this.log.warning(ex.getMessage());
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (IOException ex) {
                this.log.warning(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(boolean append) {
        OutputStreamWriter fstream = null;
        try {
            File resultFile = this.getResultFile("data.csv");
            boolean newFile = !resultFile.exists();
            resultFile.getParentFile().mkdirs();
            fstream = new FileWriter(resultFile, append);
            BufferedWriter out = new BufferedWriter(fstream);
            if (newFile) {
                out.write("ID;From;To;Type;Duration;Length;Jumps;Lifts;Location;NavPoint");
                out.newLine();
            }
            for (PathResult result : this.pathResults) {
                out.write(result.export());
                out.newLine();
            }
            out.close();
        }
        catch (IOException ex) {
            this.log.warning(ex.getMessage());
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (IOException ex) {
                this.log.warning(ex.getMessage());
            }
        }
        if (append) {
            this.pathResults.clear();
        }
    }

    private File getResultFile(String fileName) {
        String fullFilePath = FileNames.joinPath(this.resultPath, fileName);
        File resultFile = new File(fullFilePath);
        return resultFile;
    }

    public void startRecording(IAct act) {
        act.act((CommandMessage)new Record(this.getRecordName()));
    }

    public void startRecording(IAct act, Path path) {
        act.act((CommandMessage)new Record(this.getRecordName(path)));
    }

    public void stopRecording(IAct act, Path path, boolean delete) {
        act.act((CommandMessage)new StopRecord());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String recordFileName = this.getRecordName(path) + ".demo4";
        File recordFile = new File(ServerRunner.getRecordsPath(), recordFileName);
        if (delete) {
            recordFile.delete();
        } else {
            recordFile.renameTo(new File(this.resultPath, recordFileName));
        }
    }

    public void stopRecording(IAct act, boolean delete) {
        act.act((CommandMessage)new StopRecord());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String recordFileName = this.getRecordName() + ".demo4";
        File recordFile = new File(ServerRunner.getRecordsPath(), recordFileName);
        if (delete) {
            recordFile.delete();
        } else {
            recordFile.renameTo(new File(this.resultPath, recordFileName));
        }
    }

    private String getRecordName() {
        return this.getIdx() + "_";
    }

    public String getLogFile() {
        return this.resultPath + "log.log";
    }

    private String getRecordName(Path path) {
        return this.getRecordName() + path.getId().replace('.', '_');
    }

    public boolean hasFailedResult() {
        return this.failedCount > 0;
    }

    public int getTotalPaths() {
        return this.totalPaths;
    }

    public int getProcessedCount() {
        return this.processedCount;
    }

    public void setLog(LogCategory log) {
        this.log = log;
        this.isInitialized = log != null;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private int getIdx() {
        if (this.idx == 0) {
            Random r = new Random(new Date().getTime());
            this.idx = r.nextInt(1000000) + 1;
        }
        return this.idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File resultFile, int remaining) {
        this.totalPaths = remaining;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(resultFile));
            reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] splitLine = line.split(";");
                PathResult.ResultType result = PathResult.ResultType.valueOf(splitLine[3]);
                this.updateCounters(result);
                ++this.totalPaths;
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

