/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NavPoints
extends SensorModule<UT2004Bot> {
    private NavPointMaps navPoints = new NavPointMaps();
    NavPointListener navPointListener = new NavPointListener(this.worldView);
    SelfListener selfListener = new SelfListener(this.worldView);
    Self lastSelf = null;

    public NavPoint getNavPoint(UnrealId UnrealId2) {
        return (NavPoint)this.navPoints.all.get(UnrealId2);
    }

    public NavPoint getNavPoint(String name) {
        NavPoint result = (NavPoint)this.navPoints.all.get(UnrealId.get(name));
        if (result != null) {
            return result;
        }
        GameInfo info = this.worldView.getSingle(GameInfo.class);
        if (info == null) {
            return null;
        }
        return (NavPoint)this.navPoints.all.get(UnrealId.get(info.getLevel() + "." + name));
    }

    public NavPoint getNearestNavPoint() {
        if (this.lastSelf == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(this.navPoints.all.values(), this.lastSelf.getLocation());
    }

    public NavPoint getRandomNavPoint() {
        return (NavPoint)MyCollections.getRandom(this.navPoints.all.values());
    }

    public NavPoint getNearestNavPoint(ILocated location) {
        if (location == null || location.getLocation() == null) {
            return null;
        }
        return (NavPoint)DistanceUtils.getNearest(this.navPoints.all.values(), location);
    }

    public NavPoint getVisibleNavPoint(UnrealId UnrealId2) {
        return (NavPoint)this.navPoints.visible.get(UnrealId2);
    }

    public Map<UnrealId, NavPoint> getNavPoints() {
        return Collections.unmodifiableMap(this.navPoints.all);
    }

    public Map<UnrealId, NavPoint> getVisibleNavPoints() {
        return Collections.unmodifiableMap(this.navPoints.visible);
    }

    public NavPoint getRecentlyVisibleNavPoint(double recently) {
        NavPoint nearest = null;
        double distance = Double.MAX_VALUE;
        for (NavPoint plr : this.navPoints.all.values()) {
            double d;
            if (!plr.isVisible() && !((double)(this.lastSelf.getSimTime() - plr.getSimTime()) <= recently) || !((d = this.lastSelf.getLocation().getDistance(plr.getLocation())) < distance)) continue;
            distance = d;
            nearest = plr;
        }
        return nearest;
    }

    public NavPoint getNearestVisibleNavPoint() {
        return (NavPoint)DistanceUtils.getNearest(this.navPoints.visible.values(), this.lastSelf.getLocation());
    }

    public NavPoint getNearestVisibleNavPoint(Collection<NavPoint> navPoints) {
        return DistanceUtils.getNearestVisible(navPoints, this.lastSelf.getLocation());
    }

    public NavPoint getRandomVisibleNavPoint() {
        return (NavPoint)MyCollections.getRandom(this.navPoints.visible.values());
    }

    public boolean canSeeNavPoints() {
        return this.navPoints.visible.size() > 0;
    }

    public static String describe(ILocated loc) {
        if (loc == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        if (!(loc instanceof Location)) {
            if (loc instanceof Player) {
                sb.append("Player");
            }
            if (loc instanceof NavPoint) {
                sb.append(((NavPoint)loc).getId().getStringId());
            }
            if (loc instanceof Mover) {
                sb.append("Mover");
            }
            if (loc instanceof FlagInfo) {
                sb.append("Flag");
            }
            if (loc instanceof Item) {
                sb.append(((Item)loc).getType().getName());
            }
        }
        sb.append(loc.getLocation());
        if (loc instanceof NavPoint) {
            NavPoint np = (NavPoint)loc;
            if (np.isJumpPad()) {
                sb.append("[JUMP-PAD]");
            }
            if (np.isLiftCenter()) {
                sb.append("[LIFT-CENTER]");
            }
            if (np.isLiftExit()) {
                sb.append("[LIFT-EXIT]");
            }
            if (np.isTeleporter()) {
                sb.append("[TELEPORT]");
            }
        }
        if (loc instanceof IViewable) {
            sb.append("[CAN-SEE:");
            sb.append(((IViewable)((Object)loc)).isVisible());
            sb.append("]");
        }
        return sb.toString();
    }

    public NavPoints(UT2004Bot bot) {
        this(bot, (Logger)null);
    }

    public NavPoints(UT2004Bot bot, Logger log) {
        super(bot, log);
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.lastSelf = null;
        this.navPoints.clear();
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            NavPoints.this.lastSelf = NavPoints.this.lastSelf == null || NavPoints.this.lastSelf.getTeam() != event.getObject().getTeam() ? event.getObject() : event.getObject();
        }

        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, this);
        }
    }

    private class NavPointListener
    implements IWorldObjectEventListener<NavPoint, WorldObjectUpdatedEvent<NavPoint>> {
        @Override
        public void notify(WorldObjectUpdatedEvent<NavPoint> event) {
            NavPoint navPoint = (NavPoint)event.getObject();
            NavPoints.this.navPoints.notify(navPoint);
        }

        public NavPointListener(IWorldView worldView) {
            worldView.addObjectListener(NavPoint.class, WorldObjectUpdatedEvent.class, this);
        }
    }

    private class NavPointMaps {
        private HashMap<UnrealId, NavPoint> all = new HashMap();
        private HashMap<UnrealId, NavPoint> visible = new HashMap();

        private NavPointMaps() {
        }

        private void notify(NavPoint navPoint) {
            UnrealId uid = navPoint.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, navPoint);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = navPoint.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, navPoint);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
            }
        }

        private void remove(UnrealId uid) {
            this.all.remove(uid);
            this.visible.remove(uid);
        }

        private void clear() {
            this.all.clear();
            this.visible.clear();
        }
    }
}

