/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.MapPathsBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.MapPathsBotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import java.io.File;
import java.util.List;
import java.util.logging.Level;

public class MapPathsEvaluationTask
extends EvaluationTask<MapPathsBotParameters, MapPathsBot>
implements IEvaluationTask<MapPathsBotParameters, MapPathsBot> {
    private String navigation;
    private String pathPlanner;
    private String mapName;
    private String resultPath;
    private PathType pathType;
    private int batchNumber = 0;
    private boolean relevantOnly = false;
    private String level = Level.ALL.getName();

    private MapPathsEvaluationTask() {
        super(MapPathsBotParameters.class, MapPathsBot.class);
    }

    public MapPathsEvaluationTask(String mapName, String navigation, String pathPlanner, String resultPath, PathType pathType, boolean relevantOnly) {
        this();
        this.navigation = navigation;
        this.mapName = mapName;
        this.pathPlanner = pathPlanner;
        this.resultPath = resultPath;
        this.pathType = pathType;
        this.relevantOnly = relevantOnly;
    }

    public MapPathsEvaluationTask(String mapName, String navigation, String pathPlanner, String resultPath, PathType pathType, boolean relevantOnly, int batchNumber) {
        this(mapName, navigation, pathPlanner, resultPath, pathType, relevantOnly);
        this.batchNumber = batchNumber;
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public MapPathsBotParameters getBotParams() {
        return new MapPathsBotParameters(this);
    }

    public String getNavigation() {
        return this.navigation;
    }

    public String getPathPlanner() {
        return this.pathPlanner;
    }

    @Override
    public String getResultPath() {
        String fullPath = String.format("%s/%s/", this.resultPath, this.getMapName());
        File resultFile = new File(fullPath);
        resultFile.mkdirs();
        return fullPath;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public int getBatchNumber() {
        return this.batchNumber;
    }

    public boolean isBatchTask() {
        return this.batchNumber > 0;
    }

    @Deprecated
    public static MapPathsEvaluationTask buildFromArgs(String[] args) {
        if (args.length == 6) {
            return new MapPathsEvaluationTask(args[0], args[1], args[2], args[3], PathType.valueOf(args[4]), Boolean.parseBoolean(args[5]));
        }
        return null;
    }

    @Deprecated
    public void toArgs(List<String> command) {
        command.add(this.mapName);
        command.add(this.navigation);
        command.add(this.pathPlanner);
        command.add(this.resultPath);
        command.add(this.pathType.name());
    }

    @Override
    public String getLogPath() {
        return this.getResultPath() + "log.log";
    }

    @Override
    public String getFileName() {
        return String.format("MapPaths_%s_%s_%s_%d", this.navigation, this.mapName, this.pathType.name(), this.batchNumber);
    }

    public boolean getRelevantOnly() {
        return this.relevantOnly;
    }

    @Override
    public Level getLogLevel() {
        return Level.parse(this.level);
    }

    @Override
    public void setResultBasePath(String basePath) {
    }

    public static enum PathType {
        ALL,
        NO_JUMPS,
        NO_LIFTS,
        NO_JUMP_NO_LIFTS;

    }
}

