/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;

public class TestOutput {
    private static boolean log = false;
    private Queue<String> output = new LinkedList<String>();
    private String name;

    public TestOutput(String name) {
        this.name = name;
    }

    public void push(String output) {
        this.output.add(output);
    }

    public boolean consumeMany(String ... outputs) {
        for (String output : outputs) {
            if (this.consume(output)) continue;
            return false;
        }
        return true;
    }

    public boolean consume(String output) {
        if (log) {
            System.out.println("CONSUME " + this.name + " expected : " + String.valueOf(output));
        }
        if (this.output.size() == 0) {
            if (log) {
                System.out.println("CONSUME " + this.name + ": no output, can't consume: " + output);
            }
            return false;
        }
        if (output == null) {
            boolean result;
            String str = this.output.poll();
            boolean bl = result = str == null;
            if (log) {
                if (result) {
                    System.out.println("CONSUME " + this.name + " got      : " + String.valueOf(str));
                } else {
                    System.out.println("CONSUME " + this.name + " got      : " + String.valueOf(str));
                }
            }
            return result;
        }
        String str = this.output.poll();
        boolean result = output.equals(str);
        if (log) {
            if (result) {
                System.out.println("CONSUME " + this.name + " got      : " + String.valueOf(str));
            } else {
                System.out.println("CONSUME " + this.name + " got      : " + String.valueOf(str));
            }
        }
        return result;
    }

    public boolean consume(String[] output) {
        for (String str : output) {
            if (this.consume(str)) continue;
            return false;
        }
        return true;
    }

    public boolean consumeAnyOrder(String[] output) {
        HashSet<String> outputSet = new HashSet<String>();
        for (String str : output) {
            if (log) {
                System.out.println("CONSUME expected : " + String.valueOf(str));
            }
            outputSet.add(str);
        }
        if (this.output.size() < output.length) {
            if (log) {
                System.out.println("CONSUME " + this.name + ": not enough output (size = " + this.output.size() + "), needed " + output.length);
                while (this.output.size() != 0) {
                    System.out.println("CONSUME " + this.name + " listing left output: " + String.valueOf(this.output.poll()));
                }
            }
            return false;
        }
        for (int i = 0; i < output.length; ++i) {
            String str = this.output.poll();
            if (outputSet.contains(str)) {
                if (log) {
                    System.out.println("CONSUME " + this.name + " got      : " + str);
                }
            } else {
                if (log) {
                    System.out.println("CONSUME " + this.name + " got wrong: " + str);
                    while (this.output.size() != 0) {
                        System.out.println("CONSUME " + this.name + " listing left output: " + String.valueOf(this.output.poll()));
                    }
                }
                return false;
            }
            outputSet.remove(str);
        }
        return true;
    }

    public boolean isClear(boolean printIfNot) {
        if (log) {
            System.out.println("OUTPUT " + this.name + " cleared?");
        }
        if (this.output.size() == 0) {
            if (log) {
                System.out.println("OUTPUT " + this.name + " yes");
            }
            return true;
        }
        if (log) {
            System.out.println("OUTPUT " + this.name + " NO");
        }
        if (printIfNot && log) {
            this.printOutput();
        }
        return false;
    }

    public void clear() {
        this.output.clear();
    }

    public void printOutput() {
        for (String str : this.output) {
            System.out.println("OUTPUT " + this.name + ": " + str);
        }
    }

    public static boolean isLog() {
        return log;
    }

    public static void setLog(boolean log) {
        TestOutput.log = log;
    }
}

