/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;

public class ByteSource
implements ZipEntrySource {
    private final String path;
    private final byte[] bytes;
    private final long time;

    public ByteSource(String path, byte[] bytes) {
        this(path, bytes, System.currentTimeMillis());
    }

    public ByteSource(String path, byte[] bytes, long time2) {
        this.path = path;
        this.bytes = (byte[])bytes.clone();
        this.time = time2;
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry entry = new ZipEntry(this.path);
        if (this.bytes != null) {
            entry.setSize(this.bytes.length);
        }
        entry.setTime(this.time);
        return entry;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return "ByteSource[" + this.path + "]";
    }
}

