/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.SingleTaskEvaluatorBase;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.logging.Level;

public class SingleTaskEvaluator
extends SingleTaskEvaluatorBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int execute(IEvaluationTask task) {
        task.setResultBasePath(ServerRunner.getStatsBasePath());
        this.setupLog(task.getLogPath());
        int status = 0;
        UCCWrapper server = null;
        UT2004Bot bot = null;
        int stopTimeout = 21600000;
        try {
            server = SingleTaskEvaluator.run(task.getMapName());
            System.setProperty("pogamut.ut2004.server.port", Integer.toString(server.getControlPort()));
            UT2004BotRunner botRunner = new UT2004BotRunner(task.getBotClass(), "EvaluatingBot", server.getHost(), server.getBotPort());
            botRunner.setLogLevel(Level.WARNING);
            log.fine("Starting evaluation bot.");
            bot = (UT2004Bot)botRunner.startAgents(new UT2004BotParameters[]{task.getBotParams()}).get(0);
            bot.awaitState(IAgentStateDown.class, (long)stopTimeout);
        }
        catch (UCCStartException ex) {
            status = -1;
            log.throwing(SingleTaskEvaluator.class.getSimpleName(), "execute", ex);
            if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                bot.stop();
                bot.kill();
                status = -3;
            }
            if (server != null) {
                server.stop();
            }
            System.out.close();
        }
        catch (PogamutException pex) {
            block15: {
                if (bot != null && ((EvaluatingBot)bot.getController()).isCompleted()) {
                    status = 0;
                    log.fine("Evaluation completed");
                    break block15;
                }
                status = -2;
                log.throwing(SingleTaskEvaluator.class.getSimpleName(), "execute", pex);
                {
                    catch (Throwable throwable) {
                        if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                            bot.stop();
                            bot.kill();
                            status = -3;
                        }
                        if (server != null) {
                            server.stop();
                        }
                        System.out.close();
                        throw throwable;
                    }
                }
            }
            if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                bot.stop();
                bot.kill();
                status = -3;
            }
            if (server != null) {
                server.stop();
            }
            System.out.close();
        }
        if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
            bot.stop();
            bot.kill();
            status = -3;
        }
        if (server != null) {
            server.stop();
        }
        System.out.close();
        this.processResult(task);
        return status;
    }
}

