/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EnvelopeBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.TaskBotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MapEnvelopeTask
extends EvaluationTask<TaskBotParameters, EnvelopeBot>
implements IEvaluationTask<TaskBotParameters, EnvelopeBot> {
    private String mapName;
    private String resultPath;

    private MapEnvelopeTask() {
        super(TaskBotParameters.class, EnvelopeBot.class);
    }

    public MapEnvelopeTask(String mapName, String resultPath) {
        this();
        this.mapName = mapName;
        this.resultPath = resultPath;
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public String getResultPath() {
        String fullPath = String.format("%s/", this.resultPath, this.getMapName());
        File resultFile = new File(fullPath);
        resultFile.mkdirs();
        return fullPath;
    }

    @Override
    public String getLogPath() {
        return this.getResultPath() + "log.log";
    }

    @Override
    public String getFileName() {
        return String.format("%s.envelope", this.mapName);
    }

    @Override
    public void setResultBasePath(String basePath) {
    }

    @Override
    public TaskBotParameters getBotParams() {
        return new TaskBotParameters<MapEnvelopeTask>(this);
    }

    @Override
    public Level getLogLevel() {
        return Level.OFF;
    }

    public static List<MapEnvelopeTask> createBatch(List<String> mapNames, String resultPath) {
        ArrayList<MapEnvelopeTask> list = new ArrayList<MapEnvelopeTask>(mapNames.size());
        for (String map : mapNames) {
            MapEnvelopeTask task = new MapEnvelopeTask(map, resultPath);
            list.add(task);
        }
        return list;
    }
}

