/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.parser.impl.yylex;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import java.util.logging.Level;

public interface IYylexObserver {
    public void exception(Exception var1, String var2);

    public void warning(String var1);

    @AgentScoped
    public static class LogObserver
    implements IYylexObserver {
        private LogCategory log;

        @Inject
        public LogObserver(IAgentLogger agentLogger) {
            this.log = agentLogger.getCategory("Yylex");
        }

        @Override
        public void exception(Exception e, String info) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process(info, e));
            }
        }

        @Override
        public void warning(String info) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(info);
            }
        }
    }
}

