/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReact;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.module.logic.UT2004BotLogic;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncUT2004BotLogic<BOT extends UT2004Bot<? extends ILockableVisionWorldView, ?, ?>>
extends UT2004BotLogic<BOT> {
    private ObjectEventReact<ConfigChange, ?> configChangeReaction;
    private EventReact<EndMessage> endReactionAfterRespawn;
    private int shouldExecuteLogicLatch = 0;
    protected ConfigChange config;
    private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Respawn event) {
            ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
            synchronized (iCommandListener) {
                SyncUT2004BotLogic.this.endReactionAfterRespawn.enable();
                SyncUT2004BotLogic.this.shouldExecuteLogicLatch = 2;
            }
        }
    };
    protected long logicStartMillis = 0L;

    @Inject
    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, (Logger)null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void react(EndMessage event) {
                ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
                synchronized (iCommandListener) {
                    if (SyncUT2004BotLogic.this.shouldExecuteLogicLatch > 0) {
                        --SyncUT2004BotLogic.this.shouldExecuteLogicLatch;
                    }
                }
            }
        };
        ((AbstractEmbodiedAgent)agent).getAct().addCommandListener(Respawn.class, this.respawnListener);
        this.configChangeReaction = new ObjectEventReact<ConfigChange, IWorldObjectEvent<ConfigChange>>(ConfigChange.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(IWorldObjectEvent<ConfigChange> event) {
                SyncUT2004BotLogic.this.config = event.getObject();
                SyncUT2004BotLogic.this.setLogicFrequency(60.0);
            }
        };
    }

    @Override
    protected void beforeLogic(String threadName) {
        super.beforeLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Locking world view.");
        }
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).lock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view locked.");
        }
        this.logicStartMillis = System.currentTimeMillis();
    }

    @Override
    protected void afterLogic(String threadName) {
        long visionTime;
        super.afterLogic(threadName);
        long logicTime1 = System.currentTimeMillis() - this.logicStartMillis;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Unlocking world view.");
        }
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view unlocked.");
        }
        long logicTime2 = System.currentTimeMillis() - this.logicStartMillis;
        long l = visionTime = this.config == null ? 250L : (long)(this.config.getVisionTime() * 1000.0);
        if (logicTime1 > visionTime - 20L) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("!!! Bot logic takes too long: " + logicTime1 + " ms ~>" + visionTime + " == vision time, you will probably miss next update from GB2004.");
            }
        } else if (logicTime2 > visionTime - 20L && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("!!! Bot logic (" + logicTime1 + "ms) + WorldView unlocking (" + (logicTime2 - logicTime1) + "ms) takes too long: " + logicTime2 + " ms ~>" + visionTime + " == vision time, you will probably miss next update from GB2004.");
        }
    }

    @Override
    protected void afterLogicException(String threadName, Throwable e) {
        super.afterLogicException(threadName, e);
        if (((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).isLocked()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Unlocking world view.");
            }
            ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shouldExecuteLogic() {
        ICommandListener<Respawn> iCommandListener = this.respawnListener;
        synchronized (iCommandListener) {
            if (this.shouldExecuteLogicLatch != 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
                }
                return false;
            }
            return true;
        }
    }
}

