/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import com.google.common.collect.Lists;
import com.google.inject.internal.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.NodeSpace;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.Triangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import math.bsp.BspOccupation;
import math.bsp.IBspStrategy;
import math.bsp.SplitData;
import math.bsp.node.IConstBspInternalNode;
import math.bsp.node.IConstBspLeafNode;
import math.bsp.node.IConstBspNode;
import math.bsp.strat.BspListDataStrategy;
import math.geom3d.Axis3D;
import math.geom3d.Point3D;
import math.geom3d.plane.AxisAlignedPlane3D;

public class RayCastBspStrategy
extends BspListDataStrategy<Triangle, AxisAlignedPlane3D>
implements IBspStrategy<ArrayList<Triangle>, AxisAlignedPlane3D>,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final double bspAccuracy = 1.0E-4;
    protected LevelGeometry geom;
    protected Random random;
    protected transient HashMap<IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D>, NodeSpace> nodeSpaces = Maps.newHashMap();

    public RayCastBspStrategy(LevelGeometry geom, Random random) {
        this.geom = geom;
        this.random = random;
    }

    @Override
    public SplitData<ArrayList<Triangle>> splitData(AxisAlignedPlane3D boundary, ArrayList<Triangle> triangles) {
        ArrayList<Triangle> negativeTriangles = Lists.newArrayList();
        ArrayList<Triangle> positiveTriangles = Lists.newArrayList();
        for (Triangle triangle : triangles) {
            BspOccupation occupation = this.determineElementOccupation(boundary, triangle);
            if (occupation.intersectsNegative()) {
                negativeTriangles.add(triangle);
            }
            if (!occupation.intersectsPositive()) continue;
            positiveTriangles.add(triangle);
        }
        return new SplitData<ArrayList<Triangle>>(negativeTriangles, positiveTriangles);
    }

    @Override
    public AxisAlignedPlane3D findBoundary(IConstBspLeafNode<ArrayList<Triangle>, AxisAlignedPlane3D> node) {
        AxisAlignedPlane3D candidateBoundary;
        NodeSpace nodeSpace = this.getNodeSpace(node);
        AxisAlignedPlane3D bestBoundary = null;
        double bestMetric = Double.POSITIVE_INFINITY;
        int i = 0;
        while ((candidateBoundary = this.getBoundaryCandidate(node, i, this.random)) != null) {
            double leafCost;
            double s = node.getData().size();
            double sl = 0.0;
            double sr = 0.0;
            for (Triangle triangle : node.getData()) {
                BspOccupation occupation = this.determineElementOccupation(candidateBoundary, triangle);
                if (occupation.intersectsNegative()) {
                    sl += 1.0;
                }
                if (!occupation.intersectsPositive()) continue;
                sr += 1.0;
            }
            NodeSpace leftNodeSpace = nodeSpace.splitOffNegative(candidateBoundary);
            NodeSpace rightNodeSpace = nodeSpace.splitOffPositive(candidateBoundary);
            double TRIANGLE_INTERSECTION_COST = 1.125;
            double NODE_TRAVERSAL_COST = 1.0;
            double splittingCost = leftNodeSpace.getSurfaceArea() / nodeSpace.getSurfaceArea() * (TRIANGLE_INTERSECTION_COST * sl) + rightNodeSpace.getSurfaceArea() / nodeSpace.getSurfaceArea() * (TRIANGLE_INTERSECTION_COST * sr) + NODE_TRAVERSAL_COST;
            if (splittingCost < (leafCost = TRIANGLE_INTERSECTION_COST * s) && splittingCost < bestMetric) {
                bestMetric = splittingCost;
                bestBoundary = candidateBoundary;
            }
            ++i;
        }
        return bestBoundary;
    }

    public AxisAlignedPlane3D getBoundaryCandidate(IConstBspLeafNode<ArrayList<Triangle>, AxisAlignedPlane3D> node, int index, Random random) {
        ArrayList<Triangle> triangles = node.getData();
        if (triangles.size() <= 1000) {
            if (index >= triangles.size() * 6) {
                return null;
            }
            Triangle triangle = triangles.get(index / 6);
            int subindex = index % 6;
            Axis3D separationAxis = Axis3D.values()[index % 3];
            double a = separationAxis.getCoord(triangle.vertices[0]);
            double b = separationAxis.getCoord(triangle.vertices[1]);
            double c = separationAxis.getCoord(triangle.vertices[2]);
            double separationCoord = subindex < 3 ? Math.max(a, Math.max(b, c)) + 1.0E-4 : Math.min(a, Math.min(b, c)) - 1.0E-4 - 1.0E-12;
            return new AxisAlignedPlane3D(separationAxis, separationCoord);
        }
        if (index > 1000) {
            return null;
        }
        NodeSpace nodeSpace = this.getNodeSpace(node);
        Axis3D separationAxis = Axis3D.values()[index % 3];
        double separationCoord = (separationAxis.getCoord(nodeSpace.max.asPoint3D()) + separationAxis.getCoord(nodeSpace.min.asPoint3D())) / 2.0;
        if (index > 3) {
            separationCoord += (random.nextDouble() - 0.5) * ((separationAxis.getCoord(nodeSpace.max.asPoint3D()) - separationAxis.getCoord(nodeSpace.min.asPoint3D())) * 0.5);
        }
        return new AxisAlignedPlane3D(separationAxis, separationCoord);
    }

    @Override
    public boolean shouldSplit(IConstBspLeafNode<ArrayList<Triangle>, AxisAlignedPlane3D> node) {
        return node.getData().size() > 0;
    }

    @Override
    public BspOccupation determineElementOccupation(AxisAlignedPlane3D boundary, Triangle triangle) {
        boolean intersectsPositive = false;
        boolean intersectsNegative = false;
        for (int j = 0; j < 3; ++j) {
            Point3D vertex = triangle.vertices[j];
            if (boundary.getAxisCoord(vertex) <= boundary.origin + 1.0E-4) {
                intersectsPositive = true;
            }
            if (!(boundary.getAxisCoord(vertex) > boundary.origin - 1.0E-4)) continue;
            intersectsNegative = true;
        }
        return BspOccupation.get(intersectsPositive, intersectsNegative);
    }

    @Override
    public ArrayList<Triangle> joinData(ArrayList<Triangle> data1, ArrayList<Triangle> data2) {
        return super.joinData(data1, data2);
    }

    @Override
    public ArrayList<Triangle> removeData(ArrayList<Triangle> data, ArrayList<Triangle> dataToRemove) {
        return super.removeData(data, dataToRemove);
    }

    protected NodeSpace getNodeSpace(IConstBspNode<ArrayList<Triangle>, AxisAlignedPlane3D> node) {
        if (this.nodeSpaces == null) {
            this.nodeSpaces = Maps.newHashMap();
        }
        if (!this.nodeSpaces.containsKey(node)) {
            if (node.getParent() != null) {
                IConstBspInternalNode<ArrayList<Triangle>, AxisAlignedPlane3D> parent = node.getParent();
                if (parent.getNegativeChild() == node) {
                    this.nodeSpaces.put(node, this.getNodeSpace(parent).splitOffNegative(parent.getBoundary()));
                } else {
                    this.nodeSpaces.put(node, this.getNodeSpace(parent).splitOffPositive(parent.getBoundary()));
                }
            } else {
                NodeSpace treeSpace = new NodeSpace(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                for (Triangle triangle : node.getSubtreeData()) {
                    for (Point3D vertex : triangle.vertices) {
                        treeSpace.expand(new Location(vertex));
                    }
                }
                this.nodeSpaces.put(node, treeSpace);
            }
        }
        return this.nodeSpaces.get(node);
    }
}

