/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshCache;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshClearanceComputer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.grounder.NavMeshDropGrounder;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarDistanceHeuristic;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.utils.NullCheck;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class NavMeshModule {
    private IWorldView worldView;
    private Logger log;
    private boolean shouldReloadNavMesh = false;
    private GameInfo loadedForMap = null;
    private NavMesh navMesh;
    private NavMeshDropGrounder dropGrounder;
    private NavMeshAStarDistanceHeuristic aStarDistanceHeuristic;
    private NavMeshAStarPathPlanner aStarPathPlanner;
    private NavMeshClearanceComputer clearanceComputer;
    private IWorldEventListener<MapPointListObtained> mapListEndListener = new IWorldEventListener<MapPointListObtained>(){

        @Override
        public void notify(MapPointListObtained event) {
            GameInfo info = NavMeshModule.this.worldView.getSingle(GameInfo.class);
            if (info == null) {
                throw new RuntimeException("Null game info after MapPointLIstObtained event.");
            }
            NavMeshModule.this.load(info);
        }
    };

    public NavMeshModule(IUT2004ServerProvider serverProvider, IWorldView worldView, IAgentLogger logger) {
        this.log = logger == null ? new LogCategory("NavMesh") : logger.getCategory("NavMesh");
        this.worldView = worldView;
        NullCheck.check(this.worldView, "worldView");
        this.navMesh = new NavMesh(this.log);
        this.dropGrounder = new NavMeshDropGrounder(this.navMesh);
        this.aStarDistanceHeuristic = new NavMeshAStarDistanceHeuristic(this.navMesh);
        this.aStarPathPlanner = new NavMeshAStarPathPlanner(this.dropGrounder, this.navMesh, this.aStarDistanceHeuristic, this.log);
        this.clearanceComputer = new NavMeshClearanceComputer(this.dropGrounder);
        GameInfo info = worldView.getSingle(GameInfo.class);
        if (info != null) {
            this.load(info);
        } else {
            worldView.addEventListener(MapPointListObtained.class, this.mapListEndListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(GameInfo info) {
        if (info == null) {
            this.log.severe("Could not load for 'null' GameInfo!");
            return;
        }
        if (this.loadedForMap != null && this.loadedForMap.getLevel().equals(info.getLevel())) {
            return;
        }
        Map<WorldObjectId, NavPoint> worldViewOfNavPoints = this.worldView.getAll(NavPoint.class);
        HashMap<UnrealId, NavPoint> navGraph = Maps.newHashMap();
        Map<WorldObjectId, NavPoint> map = worldViewOfNavPoints;
        synchronized (map) {
            for (NavPoint navPoint : worldViewOfNavPoints.values()) {
                navGraph.put(navPoint.getId(), navPoint);
            }
        }
        if (this.shouldReloadNavMesh) {
            NavMeshCache.reloadNavMesh(this.navMesh, navGraph, info.getLevel());
        } else {
            NavMeshCache.loadNavMesh(this.navMesh, navGraph, info.getLevel());
        }
        this.loadedForMap = info;
    }

    public boolean isInitialized() {
        return this.loadedForMap != null;
    }

    public boolean shouldReloadNavMesh() {
        return this.shouldReloadNavMesh;
    }

    public void setReloadNavMesh(boolean value) {
        this.shouldReloadNavMesh = value;
    }

    public NavMesh getNavMesh() {
        return this.navMesh;
    }

    public NavMeshDropGrounder getDropGrounder() {
        return this.dropGrounder;
    }

    public NavMeshAStarDistanceHeuristic getAStarDistanceHeuristic() {
        return this.aStarDistanceHeuristic;
    }

    public NavMeshAStarPathPlanner getAStarPathPlanner() {
        return this.aStarPathPlanner;
    }

    public NavMeshClearanceComputer getClearanceComputer() {
        return this.clearanceComputer;
    }
}

