/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.IDeferredConstructor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.NodeConstructionCoordinator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import math.geom3d.Point3D;
import math.geom3d.polygon.SimplePlanarPolygon3D;

public class NavMeshPolygon
implements Serializable,
INavMeshAtom,
ILocated {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected ArrayList<NavMeshVertex> vertices = Lists.newArrayList();
    protected transient List<NavMeshVertex> constVertices;
    protected ArrayList<NavMeshEdge> edges = Lists.newArrayList();
    protected transient List<NavMeshEdge> constEdges;
    protected HashMap<Integer, NavMeshBoundary> edgeIndexToBoundaryMap = Maps.newHashMap();
    protected transient Map<Integer, NavMeshBoundary> constEdgeIndexToBoundaryMap;
    protected HashMap<NavMeshPolygon, NavMeshBoundary> adjPolygonToBoundaryMap = Maps.newHashMap();
    protected transient Map<NavMeshPolygon, NavMeshBoundary> constAdjPolygonToBoundaryMap;
    protected ArrayList<OffMeshPoint> offMeshPoints = Lists.newArrayList();
    protected transient List<OffMeshPoint> constOffMeshPoints;
    protected ArrayList<INavMeshAtom> neighbors = Lists.newArrayList();
    protected transient List<INavMeshAtom> constNeighbors;
    protected transient SimplePlanarPolygon3D shape = null;

    public NavMeshPolygon(int id, final List<Integer> vertexIds, final List<Integer> edgeIds, final Map<Integer, NavMeshBoundaryInfo> edgeIndexToBoundaryInfoMap, final Map<Integer, NavMeshBoundaryInfo> adjPolygonIdToBoundaryInfoMap, final List<NavPoint> offMeshNavPoints, final NodeConstructionCoordinator constructionCoordinator) {
        assert (id >= 0);
        this.id = id;
        this.initializeConstCollections();
        constructionCoordinator.addDeferredConstructor(new IDeferredConstructor(){

            @Override
            public void construct() {
                Iterator<Object> i$ = vertexIds.iterator();
                while (i$.hasNext()) {
                    int n = (Integer)i$.next();
                    NavMeshPolygon.this.vertices.add(constructionCoordinator.getVertexById(n));
                }
                i$ = edgeIds.iterator();
                while (i$.hasNext()) {
                    int n = (Integer)i$.next();
                    NavMeshPolygon.this.edges.add(constructionCoordinator.getEdgeById(n));
                }
                for (Map.Entry entry : edgeIndexToBoundaryInfoMap.entrySet()) {
                    NavMeshPolygon.this.edgeIndexToBoundaryMap.put((Integer)entry.getKey(), constructionCoordinator.getBoundaryByBoundaryInfo((NavMeshBoundaryInfo)entry.getValue()));
                }
                for (Map.Entry entry : adjPolygonIdToBoundaryInfoMap.entrySet()) {
                    NavMeshPolygon.this.adjPolygonToBoundaryMap.put(constructionCoordinator.getPolygonById((Integer)entry.getKey()), constructionCoordinator.getBoundaryByBoundaryInfo((NavMeshBoundaryInfo)entry.getValue()));
                }
                for (NavPoint navPoint : offMeshNavPoints) {
                    NavMeshPolygon.this.offMeshPoints.add(constructionCoordinator.getOffMeshPointByNavPoint(navPoint));
                }
                NavMeshPolygon.this.neighbors.addAll(NavMeshPolygon.this.adjPolygonToBoundaryMap.keySet());
                NavMeshPolygon.this.neighbors.addAll(NavMeshPolygon.this.offMeshPoints);
            }
        });
    }

    public int getId() {
        return this.id;
    }

    public Map<NavMeshPolygon, NavMeshBoundary> getAdjPolygonToBoundaryMap() {
        return this.constAdjPolygonToBoundaryMap;
    }

    public List<OffMeshPoint> getOffMeshPoints() {
        return this.constOffMeshPoints;
    }

    @Override
    public List<INavMeshAtom> getNeighbors() {
        return this.constNeighbors;
    }

    public List<NavMeshVertex> getVertices() {
        return this.constVertices;
    }

    public List<NavMeshEdge> getEdges() {
        return this.constEdges;
    }

    public Map<Integer, NavMeshBoundary> getEdgeIndexToBoundaryMap() {
        return this.constEdgeIndexToBoundaryMap;
    }

    @Override
    public Location getLocation() {
        return this.getCenter();
    }

    public Location getCenter() {
        return new Location(this.getShape().getCentroid());
    }

    public double getDistance(Location location) {
        return this.getShape().getDistance(location.asPoint3D());
    }

    public SimplePlanarPolygon3D getShape() {
        if (this.shape == null) {
            ArrayList<Point3D> point3dVertices = new ArrayList<Point3D>();
            for (NavMeshVertex vertex : this.vertices) {
                point3dVertices.add(vertex.getLocation().asPoint3D());
            }
            this.shape = new SimplePlanarPolygon3D(point3dVertices);
        }
        return this.shape;
    }

    public int hashCode() {
        return 23 * this.id;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append("NMP( " + this.id);
        for (NavMeshVertex vertex : this.vertices) {
            retval.append(", " + vertex.toString());
        }
        retval.append(" )");
        return retval.toString();
    }

    protected void initializeConstCollections() {
        this.constVertices = Collections.unmodifiableList(this.vertices);
        this.constEdges = Collections.unmodifiableList(this.edges);
        this.constEdgeIndexToBoundaryMap = Collections.unmodifiableMap(this.edgeIndexToBoundaryMap);
        this.constAdjPolygonToBoundaryMap = Collections.unmodifiableMap(this.adjPolygonToBoundaryMap);
        this.constOffMeshPoints = Collections.unmodifiableList(this.offMeshPoints);
        this.constNeighbors = Collections.unmodifiableList(this.neighbors);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConstCollections();
    }
}

