/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.IDeferredConstructor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.construction.NodeConstructionCoordinator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NavMeshVertex
implements Serializable,
ILocated {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected Location location;
    protected HashMap<NavMeshPolygon, Integer> polygonToVertexIndexMap = Maps.newHashMap();
    protected transient Map<NavMeshPolygon, Integer> constPolygonToVertexIndexMap;
    protected ArrayList<NavMeshEdge> edges = Lists.newArrayList();
    protected transient List<NavMeshEdge> constEdges;
    protected boolean isOnWalkableAreaEdge;

    public NavMeshVertex(int id, Location location, final Map<Integer, Integer> polygonIdToVertexIndexMap, final List<Integer> edgeIds, boolean isOnWalkableAreaEdge, final NodeConstructionCoordinator constructionCoordinator) {
        this.id = id;
        this.location = location;
        this.isOnWalkableAreaEdge = isOnWalkableAreaEdge;
        this.initializeConstCollections();
        constructionCoordinator.addDeferredConstructor(new IDeferredConstructor(){

            @Override
            public void construct() {
                for (Map.Entry entry : polygonIdToVertexIndexMap.entrySet()) {
                    NavMeshVertex.this.polygonToVertexIndexMap.put(constructionCoordinator.getPolygonById((Integer)entry.getKey()), (Integer)entry.getValue());
                }
                for (Integer edgeId : edgeIds) {
                    NavMeshVertex.this.edges.add(constructionCoordinator.getEdgeById(edgeId));
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public Map<NavMeshPolygon, Integer> getPolygonToVertexIndexMap() {
        return this.constPolygonToVertexIndexMap;
    }

    public List<NavMeshEdge> getEdges() {
        return this.constEdges;
    }

    public boolean isOnWalkableAreaEdge() {
        return this.isOnWalkableAreaEdge;
    }

    public String toString() {
        return "NMV( " + this.id + ", " + this.location.toString() + " )";
    }

    protected void initializeConstCollections() {
        this.constPolygonToVertexIndexMap = Collections.unmodifiableMap(this.polygonToVertexIndexMap);
        this.constEdges = Collections.unmodifiableList(this.edges);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConstCollections();
    }
}

