/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.old;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.old.OldOffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import math.geom2d.Vector2D;

public class OldNavMeshConstants {
    public static String pureMeshReadDir = "navmesh";
    public static String processedMeshDir = "navmesh";
    public static String pureLevelGeometryReadDir = "map";
    public static String processedLevelGeometryDir = "map";
    public static int stopSplittingNumberOfPolygons = 1;
    public static int maxNumberOfPolygonsToTry = 10;
    public static double maxAllowedSplitFactor = 1.0;
    public static int stopSplittingNumberOfTriangles = 20;
    public static double stopSplittingSizeOfOneBlock = 40.0;
    public static double maxAllowedCrossFactor = 0.6;
    public static double UTHalfAngle = 32768.0;
    public static double UTQuarterAngle = UTHalfAngle / 2.0;
    public static double ForceToTarget = 1.0;
    public static double StepSize = 75.0;
    public static double obstacleMaxForce = 1.5;
    public static double obstacleMaxDistance = 100.0;
    public static double maxDistanceBotPolygon = 90.0;
    public static double liftPolygonLocation = 40.0;
    public static double agentRadius = 0.0;

    public static Location getColorForOffMeshConnection(OldOffMeshEdge oe, UT2004Server server) {
        NavPoint from = ((UT2004WorldView)server.getWorldView()).get(oe.getFrom().getNavPointId(), NavPoint.class);
        NavPoint to = ((UT2004WorldView)server.getWorldView()).get(oe.getTo().getNavPointId(), NavPoint.class);
        if (from == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        if (to == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        if (from.isLiftCenter() || to.isLiftCenter()) {
            return new Location(0.0, 0.0, 255.0);
        }
        if (from.isTeleporter() && to.isTeleporter()) {
            return new Location(150.0, 0.0, 255.0);
        }
        NavPointNeighbourLink link = from.getOutgoingEdges().get(oe.getLinkId());
        if (link == null) {
            return new Location(255.0, 255.0, 100.0);
        }
        int linkFlags = link.getFlags();
        if ((linkFlags & LinkFlag.DOOR.get()) > 0) {
            // empty if block
        }
        if ((linkFlags & LinkFlag.FLY.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.FORCED.get()) > 0) {
            return new Location(255.0, 170.0, 255.0);
        }
        if ((linkFlags & LinkFlag.LADDER.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.PLAYERONLY.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.PROSCRIBED.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.SPECIAL.get()) > 0) {
            return new Location(255.0, 0.0, 255.0);
        }
        if ((linkFlags & LinkFlag.SWIM.get()) > 0) {
            return new Location(255.0, 0.0, 0.0);
        }
        if ((linkFlags & LinkFlag.WALK.get()) > 0) {
            // empty if block
        }
        if ((linkFlags & LinkFlag.JUMP.get()) > 0) {
            return new Location(100.0, 255.0, 255.0);
        }
        return new Location(255.0, 255.0, 100.0);
    }

    public static double transform2DVectorToRotation(Vector2D vector) {
        double x = vector.getX();
        double y = vector.getY();
        double yaw = x == 0.0 ? (y >= 0.0 ? UTQuarterAngle : 3.0 * UTQuarterAngle) : (y == 0.0 ? (x >= 0.0 ? 0.0 : 2.0 * UTQuarterAngle) : (y > 0.0 ? (x > 0.0 ? 0.0 * UTQuarterAngle + Math.atan(y / x) / (Math.PI * 2) * 65536.0 : 1.0 * UTQuarterAngle + Math.atan(-x / y) / (Math.PI * 2) * 65536.0) : (x < 0.0 ? 2.0 * UTQuarterAngle + Math.atan(-y / -x) / (Math.PI * 2) * 65536.0 : 3.0 * UTQuarterAngle + Math.atan(x / -y) / (Math.PI * 2) * 65536.0)));
        return yaw;
    }

    public static Vector2D transformRotationTo2DVector(double yaw) {
        Vector2D direction = null;
        while (yaw < 0.0) {
            yaw += 65536.0;
        }
        double yawRad = (yaw %= 65536.0) / 65536.0 * 2.0 * Math.PI;
        if (yaw % UTQuarterAngle == 0.0) {
            if (yaw == 0.0 * UTQuarterAngle) {
                direction = new Vector2D(1.0, 0.0);
            }
            if (yaw == 1.0 * UTQuarterAngle) {
                direction = new Vector2D(0.0, 1.0);
            }
            if (yaw == 2.0 * UTQuarterAngle) {
                direction = new Vector2D(-1.0, 0.0);
            }
            if (yaw == 3.0 * UTQuarterAngle) {
                direction = new Vector2D(0.0, -1.0);
            }
        } else {
            direction = yaw < 2.0 * UTQuarterAngle ? (yaw < 1.0 * UTQuarterAngle ? new Vector2D(1.0, Math.tan(yawRad)) : new Vector2D(-Math.tan(yawRad - 1.5707963267948966), 1.0)) : (yaw < 3.0 * UTQuarterAngle ? new Vector2D(-1.0, Math.tan(yawRad - Math.PI)) : new Vector2D(-Math.tan(yawRad - 4.71238898038469), -1.0));
        }
        return direction.getNormalizedVector();
    }
}

