/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar;

import com.google.common.collect.Sets;
import com.google.inject.internal.Maps;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.INavMeshAStarHeuristic;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.AStar.NavMeshAStarNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class NavMeshAStarDistanceHeuristic
implements INavMeshAStarHeuristic {
    protected NavMesh navMesh;
    protected HashMap<OffMeshPoint, Double> teleporterToDistanceToCachedDestinationMap = null;
    protected Location cachedDestination = null;

    public NavMeshAStarDistanceHeuristic(NavMesh navMesh) {
        this.navMesh = navMesh;
    }

    public double computeCost(NavMeshAStarNode from, INavMeshAtom adjacentAtom) {
        INavMeshAtom fromAtom = from.getAtom();
        if (fromAtom instanceof NavMeshPolygon && adjacentAtom instanceof NavMeshPolygon) {
            return fromAtom.getLocation().getDistance(adjacentAtom.getLocation());
        }
        if (fromAtom instanceof OffMeshPoint && adjacentAtom instanceof OffMeshPoint) {
            OffMeshPoint fromOffMeshPoint = (OffMeshPoint)fromAtom;
            if (fromOffMeshPoint.getNavPoint().isTeleporter()) {
                return 0.0;
            }
            return fromAtom.getLocation().getDistance(adjacentAtom.getLocation());
        }
        return 0.0;
    }

    public double estimateCost(INavMeshAtom from, INavMeshAtom to) {
        this.ensureTeleporterDistancesUpToDate(to.getLocation());
        double retval = from.getLocation().getDistance(to.getLocation());
        for (Map.Entry<OffMeshPoint, Double> entry : this.teleporterToDistanceToCachedDestinationMap.entrySet()) {
            double distanceViaTeleporter = from.getLocation().getDistance(entry.getKey().getLocation()) + entry.getValue();
            retval = Math.min(retval, distanceViaTeleporter);
        }
        return retval;
    }

    @Override
    public NavMeshAStarNode extend(NavMeshAStarNode node, INavMeshAtom adjacentAtom, INavMeshAtom destinationAtom) {
        double costFromStartToAdjacent = 0.0;
        if (node != null) {
            costFromStartToAdjacent = node.getCostFromStart() + this.computeCost(node, adjacentAtom);
        }
        double estimatedCostFromAdjacentToDestination = this.estimateCost(adjacentAtom, destinationAtom);
        return new NavMeshAStarNode(node, adjacentAtom, costFromStartToAdjacent, estimatedCostFromAdjacentToDestination);
    }

    protected void ensureTeleporterDistancesUpToDate(Location destination) {
        if (this.cachedDestination != null && this.cachedDestination.equals(destination)) {
            return;
        }
        this.cachedDestination = destination;
        if (this.teleporterToDistanceToCachedDestinationMap == null) {
            this.teleporterToDistanceToCachedDestinationMap = Maps.newHashMap();
            for (OffMeshPoint point : this.navMesh.getOffMeshPoints()) {
                if (!point.getNavPoint().isTeleporter()) continue;
                this.teleporterToDistanceToCachedDestinationMap.put(point, null);
            }
        }
        HashMap<Location, Double> sinkToDistanceMap = Maps.newHashMap();
        sinkToDistanceMap.put(destination, 0.0);
        HashSet<OffMeshPoint> unusedTeleporters = Sets.newHashSet(this.teleporterToDistanceToCachedDestinationMap.keySet());
        while (unusedTeleporters.size() > 0) {
            OffMeshPoint teleporterWithClosestExit = null;
            Double teleporterWithClosestExitCostEstimate = Double.POSITIVE_INFINITY;
            for (OffMeshPoint candidateTeleporter : unusedTeleporters) {
                assert (candidateTeleporter.getOutgoingEdges().size() == 1);
                Location candidateTeleporterExit = candidateTeleporter.getOutgoingEdges().iterator().next().getTo().getLocation();
                double candidateCostEstimate = Double.POSITIVE_INFINITY;
                for (Map.Entry sinkEntry : sinkToDistanceMap.entrySet()) {
                    double sinkCostEstimate = candidateTeleporterExit.getDistance((Location)sinkEntry.getKey()) + (Double)sinkEntry.getValue();
                    sinkCostEstimate = Math.min(candidateCostEstimate, sinkCostEstimate);
                }
                if (!(candidateCostEstimate < teleporterWithClosestExitCostEstimate)) continue;
                teleporterWithClosestExit = candidateTeleporter;
                teleporterWithClosestExitCostEstimate = candidateCostEstimate;
            }
            sinkToDistanceMap.put(teleporterWithClosestExit.getLocation(), teleporterWithClosestExitCostEstimate);
            this.teleporterToDistanceToCachedDestinationMap.put(teleporterWithClosestExit, teleporterWithClosestExitCostEstimate);
            unusedTeleporters.remove(teleporterWithClosestExit);
        }
    }
}

