/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.BooleanProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LocationProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ItemSharedImpl
extends ItemShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(2);
    protected UnrealId Id = null;
    protected LocationProperty myLocation = null;
    protected BooleanProperty myDropped = null;

    public ItemSharedImpl(ItemSharedImpl source) {
        this.Id = source.getId();
        this.myLocation = source.myLocation;
        this.myDropped = source.myDropped;
    }

    public ItemSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check(this.Id, "objectId");
        if (properties.size() != 2) {
            throw new PogamutException("Not enough properties passed to the constructor.", ItemSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals(property.getObjectId())) {
                throw new PogamutException("Trying to create a ItemSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!ItemShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a ItemSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
            if (pId.getPropertyToken().getToken().equals("Location")) {
                this.myLocation = (LocationProperty)property;
            }
            if (!pId.getPropertyToken().getToken().equals("Dropped")) continue;
            this.myDropped = (BooleanProperty)property;
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public ItemSharedImpl clone() {
        return new ItemSharedImpl(this);
    }

    @Override
    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    @Override
    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public Location getLocation() {
        return (Location)this.myLocation.getValue();
    }

    @Override
    public boolean isDropped() {
        return (Boolean)this.myDropped.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Dropped = " + String.valueOf(this.isDropped()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Dropped</b> = " + String.valueOf(this.isDropped()) + " <br/> " + "<br/>]";
    }

    public static class ItemSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private ItemShared object;
        private long time;
        private ITeamId teamId;

        public ItemSharedUpdate(ItemShared data, long time2, ITeamId teamId) {
            this.object = data;
            this.time = time2;
            this.teamId = teamId;
        }

        @Override
        public long getSimTime() {
            return this.time;
        }

        @Override
        public WorldObjectId getId() {
            return this.object.getId();
        }

        @Override
        public ITeamId getTeamId() {
            return this.teamId;
        }

        @Override
        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        @Override
        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

