/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import com.google.common.io.Files;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.SingleNavigationTaskEvaluator;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTaskFactory;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import java.io.File;
import java.io.IOException;

public class DirectRunner {
    private ServerRunner serverRunner;
    private String label;

    public DirectRunner(ServerRunner serverRunner, String label) {
        this.serverRunner = serverRunner;
        this.label = label;
    }

    public void run(boolean isResume) {
        File taskFile;
        IEvaluationTask task;
        boolean done = this.serverRunner.getTasks().isEmpty();
        while (!done && (task = EvaluationTaskFactory.build(taskFile = this.serverRunner.getFreeTask())) != null) {
            task.setResultBasePath(ServerRunner.getStatsBasePath());
            File taskDefFile = new File(task.getResultPath(), taskFile.getName());
            try {
                taskDefFile.delete();
                Files.copy(taskFile, taskDefFile);
            }
            catch (IOException ex) {
                // empty catch block
            }
            SingleNavigationTaskEvaluator evaluator = new SingleNavigationTaskEvaluator();
            int result = evaluator.execute(task, isResume, this.label);
            if (result == 0) {
                this.serverRunner.getTasks().remove(taskFile);
            }
            done = this.serverRunner.getTasks().isEmpty();
        }
    }
}

