/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.LocationUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationFactory;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;

public class JumpInspectingBotFall
extends EvaluatingBot {
    private boolean respawning;
    private IWorldEventListener<LocationUpdate> listener;
    Phase phase = Phase.ToStart;
    double jumpDistance = 400.0;
    NavPoint startSpot = null;
    Location endSpot = null;
    int step = 0;
    boolean inEvaluation = false;
    boolean jumpedAlready = false;
    boolean inJump = false;
    Location beforeJumpMax = null;
    Location afterJumpMax = null;
    Location beforeJumpMin = null;
    Location afterJumpMin = null;
    private IPathPlanner myPathPlanner;
    private IUT2004Navigation myNavigation;
    double zOnTheGround = -78.15;
    int jumpCount = 0;
    double maxJump = Double.NEGATIVE_INFINITY;
    private double maxJumpDelay;
    boolean turned = false;

    protected void initializePathFinding(UT2004Bot bot) {
        super.initializePathFinding(bot);
        this.myPathPlanner = NavigationFactory.getPathPlanner(this, bot, "navMesh");
        this.myNavigation = NavigationFactory.getNavigation(this, bot, "acc");
    }

    @Override
    public void beforeFirstLogic() {
        super.beforeFirstLogic();
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.bot.getLog().setLevel(Level.WARNING);
        this.move.getLog().setLevel(Level.WARNING);
        this.listener = new IWorldEventListener<LocationUpdate>(){

            @Override
            public void notify(LocationUpdate t) {
                LocationUpdate locationUpdate = t;
                Phase lastPhase = JumpInspectingBotFall.this.phase;
                switch (lastPhase) {
                    case Running: {
                        if (JumpInspectingBotFall.this.inJump) {
                            JumpInspectingBotFall.this.log.warning("LOCATION UPDATE - L: {0}\tV: {1}\tR: {2}\tSimTime: {3}", new Object[]{locationUpdate.getLoc(), locationUpdate.getVel(), locationUpdate.getRot(), locationUpdate.getSimTime()});
                        }
                        if (!JumpInspectingBotFall.this.inJump || JumpInspectingBotFall.this.isOnTheGround(locationUpdate.getLoc())) break;
                        JumpInspectingBotFall.this.phase = Phase.Jumping;
                        break;
                    }
                    case Jumping: {
                        if (locationUpdate.getLoc().z > JumpInspectingBotFall.this.maxJump) {
                            JumpInspectingBotFall.this.maxJump = locationUpdate.getLoc().z;
                        }
                        JumpInspectingBotFall.this.log.warning("LOCATION UPDATE - L: {0}\tV: {1}\tR: {2}\tSimTime: {3}", new Object[]{locationUpdate.getLoc(), locationUpdate.getVel(), locationUpdate.getRot(), locationUpdate.getSimTime()});
                        if (!JumpInspectingBotFall.this.isOnTheGround(locationUpdate.getLoc()) || locationUpdate.getVel().z != 0.0) break;
                        JumpInspectingBotFall.this.phase = Phase.AfterJump;
                        JumpInspectingBotFall.this.inJump = false;
                    }
                }
                switch (JumpInspectingBotFall.this.phase) {
                    case Running: {
                        JumpInspectingBotFall.this.beforeJumpMax = locationUpdate.getLoc();
                        break;
                    }
                    case Jumping: {
                        if (lastPhase == Phase.Running) {
                            JumpInspectingBotFall.this.beforeJumpMin = locationUpdate.getLoc();
                        }
                        JumpInspectingBotFall.this.afterJumpMin = locationUpdate.getLoc();
                        break;
                    }
                    case AfterJump: {
                        if (lastPhase != Phase.Jumping) break;
                        JumpInspectingBotFall.this.afterJumpMax = locationUpdate.getLoc();
                        double jumpLengthMax = JumpInspectingBotFall.this.afterJumpMax.getDistance2D(JumpInspectingBotFall.this.beforeJumpMax);
                        double jumpLengthMin = JumpInspectingBotFall.this.afterJumpMin.getDistance2D(JumpInspectingBotFall.this.beforeJumpMin);
                        JumpInspectingBotFall.this.log.log(Level.WARNING, "JUMP FINISHED: MAX: {0} MIN: {1}", new Object[]{jumpLengthMax, jumpLengthMin});
                        JumpInspectingBotFall.this.log.log(Level.WARNING, "Before MAX loc: {0}", JumpInspectingBotFall.this.beforeJumpMax);
                        JumpInspectingBotFall.this.log.log(Level.WARNING, "After MAX loc: {0}", JumpInspectingBotFall.this.afterJumpMax);
                        JumpInspectingBotFall.this.log.log(Level.WARNING, "Before MIN loc: {0}", JumpInspectingBotFall.this.beforeJumpMin);
                        JumpInspectingBotFall.this.log.log(Level.WARNING, "After MIN loc: {0}", JumpInspectingBotFall.this.afterJumpMin);
                    }
                }
            }
        };
        this.world.addEventListener(LocationUpdate.class, this.listener);
        this.myNavigation.addStrongNavigationListener(new FlagListener<NavigationState>(){

            @Override
            public void flagChanged(NavigationState changedValue) {
                if (changedValue == NavigationState.TARGET_REACHED && JumpInspectingBotFall.this.phase == Phase.ToStart && JumpInspectingBotFall.this.bot.getLocation().getDistance2D(JumpInspectingBotFall.this.startSpot.getLocation()) < 100.0) {
                    JumpInspectingBotFall.this.phase = Phase.OnStart;
                }
            }
        });
        String firstSpotId = "DM-1on1-Idoma.PathNode25";
        String secondSpotId = "DM-1on1-Idoma.PlayerStart2";
        this.startSpot = this.navPoints.getNavPoint(UnrealId.get(firstSpotId));
        this.endSpot = this.navPoints.getNavPoint(UnrealId.get(secondSpotId)).getLocation();
    }

    @Override
    public void logic() {
        if (this.bot.getVelocity().size() < 10.0) {
            switch (this.phase) {
                case ToStart: {
                    this.body.getAction().respawn(this.startSpot);
                    this.phase = Phase.OnStart;
                    break;
                }
                case OnStart: {
                    if (!this.info.atLocation(this.startSpot)) break;
                    this.zOnTheGround = this.bot.getLocation().z;
                    this.act.act(new Move(this.endSpot, null, null, this.endSpot));
                    this.phase = Phase.Running;
                    break;
                }
                default: {
                    this.phase = Phase.ToStart;
                }
            }
        }
        if (this.phase == Phase.Running && this.isOnTheGround(this.bot.getLocation()) && this.navPoints.getNavPoint(UnrealId.get("DM-1on1-Idoma.PathNode36")).getLocation().getDistance(this.bot.getLocation()) < 100.0) {
            this.move.jump(true, 0.39, 755.0);
            this.log.warning("JUMP INITIATED");
            this.inJump = true;
            ++this.jumpCount;
        }
        if (this.jumpCount > 10) {
            this.log.log(Level.WARNING, "MAX JUMP: {0}", this.maxJump);
            this.log.info("No more jumps to jump, we are finished...");
            this.isCompleted = true;
            new Runnable(){

                @Override
                public void run() {
                    JumpInspectingBotFall.this.bot.stop();
                }
            }.run();
        }
    }

    @Override
    public void botKilled(BotKilled event) {
        super.botKilled(event);
        this.respawning = false;
        this.log.info("Already respawning...");
    }

    private boolean isOnTheGround(Location location) {
        return location.z <= this.zOnTheGround + 1.0;
    }

    public static enum Phase {
        ToStart,
        OnStart,
        Running,
        Jumping,
        AfterJump,
        AtEnd;

    }
}

