/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import java.util.List;

public class Path {
    private NavPoint start;
    private NavPoint end;
    private double length = 0.0;
    private int jumps = 0;
    private int lifts = 0;

    public Path(NavPoint start, NavPoint end) {
        this.start = start;
        this.end = end;
    }

    public NavPoint getStart() {
        return this.start;
    }

    public NavPoint getEnd() {
        return this.end;
    }

    public String getId() {
        return String.format("[%s]-[%s]", this.start.getId().getStringId(), this.end.getId().getStringId());
    }

    public double getLength() {
        return this.length;
    }

    public int getJumps() {
        return this.jumps;
    }

    public int getLifts() {
        return this.lifts;
    }

    public void computeMetrics(IPathFuture<ILocated> path) {
        List<ILocated> list = path.get();
        this.length = this.getPathLength(list);
        this.jumps = this.getJumpCount(list);
        this.lifts = this.getLiftCount(list);
    }

    private double getPathLength(List<ILocated> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Location l1 = list.get(i).getLocation();
            Location l2 = list.get(i + 1).getLocation();
            double distance = l1.getDistance(l2);
            sum += distance;
        }
        return sum;
    }

    private int getJumpCount(List<ILocated> list) {
        int jumpCount = 0;
        ILocated fromLocation = list.get(0);
        ILocated toLocation = list.get(1);
        for (int i = 2; i < list.size(); ++i) {
            if (fromLocation.getClass() == NavPointMessage.class && toLocation.getClass() == NavPointMessage.class) {
                boolean isJump;
                NavPointMessage from = (NavPointMessage)fromLocation;
                NavPointMessage to = (NavPointMessage)toLocation;
                NavPointNeighbourLink edge = from.getOutgoingEdges().get(to.getId());
                if (edge == null) continue;
                int jumpFlag = 8;
                boolean bl = isJump = (edge.getFlags() & jumpFlag) == jumpFlag;
                if (isJump) {
                    ++jumpCount;
                }
            }
            fromLocation = toLocation;
            toLocation = list.get(i);
        }
        return jumpCount;
    }

    private int getLiftCount(List<ILocated> list) {
        int liftCount = 0;
        for (int i = 0; i < list.size(); ++i) {
            NavPointMessage node;
            ILocated fromLocation = list.get(i);
            if (fromLocation.getClass() != NavPointMessage.class || !(node = (NavPointMessage)fromLocation).isLiftCenter()) continue;
            ++liftCount;
        }
        return liftCount;
    }
}

