/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.FileNames;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.BotNavigationParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationEvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.RecordType;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.INavigationEvaluationTask;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class NavigationEvaluationTask
extends EvaluationTask<BotNavigationParameters, NavigationEvaluatingBot>
implements INavigationEvaluationTask {
    private String navigation;
    private String pathPlanner;
    private String mapName;
    private boolean onlyRelevantPaths;
    private String resultPath = null;
    private String resultBasePath;
    private RecordType recordType;
    private int limit;
    private String stringLevel;

    public NavigationEvaluationTask(String navigation, String pathPlanner, String mapName, boolean onlyRelevantPaths, int limit, String resultBasePath, RecordType recordType, Level level) {
        super(BotNavigationParameters.class, NavigationEvaluatingBot.class);
        this.navigation = navigation;
        this.pathPlanner = pathPlanner;
        this.mapName = mapName;
        this.onlyRelevantPaths = onlyRelevantPaths;
        this.limit = limit;
        this.recordType = recordType;
        this.stringLevel = level.getName();
        this.resultBasePath = resultBasePath;
    }

    @Deprecated
    public NavigationEvaluationTask(String navigation, String pathPlanner, String mapName, boolean onlyRelevantPaths, String resultPath) {
        this(navigation, pathPlanner, mapName, onlyRelevantPaths, 30, resultPath, RecordType.FULL, Level.ALL);
    }

    @Deprecated
    public NavigationEvaluationTask() {
        this("navigation", "fwMap", "DM-TrainingDay", true, 10, "C:/Temp/Pogamut/stats/", RecordType.FULL, Level.ALL);
    }

    @Deprecated
    public static NavigationEvaluationTask buildFromArgs(String[] args) {
        if (args.length == 8) {
            return new NavigationEvaluationTask(args[0], args[1], args[2], Boolean.parseBoolean(args[3]), Integer.parseInt(args[4]), args[5], RecordType.valueOf(args[6]), Level.parse(args[7]));
        }
        return new NavigationEvaluationTask();
    }

    @Override
    public BotNavigationParameters getBotParams() {
        return new BotNavigationParameters(this);
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public boolean isOnlyRelevantPaths() {
        return this.onlyRelevantPaths;
    }

    @Override
    public String getNavigation() {
        return this.navigation;
    }

    @Override
    public String getPathPlanner() {
        return this.pathPlanner;
    }

    @Override
    public String getResultPath() {
        if (this.resultPath == null) {
            String basePath = String.format("%s/%s_%s/%s", this.resultBasePath, this.navigation, this.pathPlanner, this.mapName);
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy_HHmmss");
            String fullPath = String.format("%s/%s/", basePath, dateFormat.format(new Date()));
            File resultFile = new File(fullPath);
            resultFile.mkdirs();
            this.resultPath = fullPath;
        }
        return this.resultPath;
    }

    public String getResultBasePath() {
        return this.resultBasePath;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public String getLogPath() {
        return FileNames.joinPath(this.getResultPath(), "log.log");
    }

    @Override
    public void setNavigation(String navigation) {
        this.navigation = navigation;
    }

    @Override
    public void setPathPlanner(String pathPlanner) {
        this.pathPlanner = pathPlanner;
    }

    @Override
    public void setOnlyRelevantPaths(boolean onlyRelevantPaths) {
        this.onlyRelevantPaths = onlyRelevantPaths;
    }

    @Override
    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Deprecated
    public void toArgs(List<String> command) {
        command.add(this.navigation);
        command.add(this.pathPlanner);
        command.add(this.mapName);
        command.add(Boolean.toString(this.onlyRelevantPaths));
        command.add(Integer.toString(this.limit));
        command.add(this.resultBasePath);
        command.add(this.recordType.name());
    }

    @Override
    public String getFileName() {
        return String.format("NavigationEvaluation_%s_%s_%s", this.navigation, this.pathPlanner, this.mapName);
    }

    @Override
    public Level getLogLevel() {
        return Level.parse(this.stringLevel);
    }

    @Override
    public void setResultBasePath(String basePath) {
        this.resultBasePath = this.resultBasePath.isEmpty() ? basePath : this.resultBasePath.replace("base:", basePath);
        this.resultPath = null;
    }
}

