/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.iterators;

import java.util.Iterator;

public class CircularIterator<E>
implements Iterator<E> {
    protected boolean passedEnd = false;
    private Iterable<E> toIterateOver;
    private Iterator<E> iterator;

    public CircularIterator(Iterable<E> toIterateOver) {
        this.toIterateOver = toIterateOver;
        this.iterator = toIterateOver.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.toIterateOver.iterator().hasNext();
    }

    @Override
    public E next() {
        E value = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.restartIterator();
            this.passedEnd = true;
        }
        return value;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public boolean hasPassedEnd() {
        if (this.passedEnd) {
            this.passedEnd = false;
            return this.passedEnd;
        }
        return false;
    }

    protected Iterable<E> getIterable() {
        return this.toIterateOver;
    }

    protected Iterator<E> getIterator() {
        return this.iterator;
    }

    protected void restartIterator() {
        this.iterator = this.toIterateOver.iterator();
    }
}

