/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.logging;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DefaultLogFormatter
extends Formatter {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static String longestUnitName = "";
    private static String longestComponentName = "";
    private StringBuffer buffer = new StringBuffer(512);
    protected boolean lineEnds = false;
    protected String lineEnd = "\r\n";
    protected String name = null;
    public static final String[] whitespaces = new String[]{"        ", "       ", "      ", "     ", "    ", "   ", "  ", " ", ""};

    public DefaultLogFormatter() {
        this(null, false);
    }

    public DefaultLogFormatter(String unitName) {
        this.name = unitName;
    }

    public DefaultLogFormatter(String unitName, boolean appendLineEnd) {
        this.name = unitName;
        this.lineEnds = appendLineEnd;
    }

    @Override
    public synchronized String format(LogRecord record) {
        int i;
        String n;
        this.buffer.delete(0, this.buffer.length());
        if (this.name != null) {
            n = this.name;
            if (n == null) {
                n = "null";
            }
            if (n.length() > longestUnitName.length()) {
                StringBuffer longest = new StringBuffer();
                for (i = 0; i < n.length(); ++i) {
                    longest.append(" ");
                }
                longestUnitName = longest.toString();
            }
            this.buffer.append("(");
            this.buffer.append(n);
            this.buffer.append(") ");
            int count = longestUnitName.length() - n.length();
            for (i = 0; i < count; ++i) {
                this.buffer.append(" ");
            }
        } else if (longestUnitName.length() > 0) {
            this.buffer.append("()");
            this.buffer.append(longestUnitName);
        } else {
            this.buffer.append("() ");
        }
        this.buffer.append("[");
        this.buffer.append(record.getLevel().toString());
        this.buffer.append("]");
        this.buffer.append(whitespaces[record.getLevel().toString().length()]);
        this.buffer.append(this.dateFormat.format(new Date(record.getMillis())));
        this.buffer.append(" ");
        n = record.getLoggerName();
        if (n == null) {
            n = "null";
        }
        if (n.length() > longestComponentName.length()) {
            StringBuffer longest = new StringBuffer();
            for (i = 0; i < n.length(); ++i) {
                longest.append(" ");
            }
            longestComponentName = longest.toString();
        }
        this.buffer.append("<");
        this.buffer.append(n);
        this.buffer.append("> ");
        int count = longestComponentName.length() - n.length();
        for (i = 0; i < count; ++i) {
            this.buffer.append(" ");
        }
        Object[] params = record.getParameters();
        if (params == null || params.length <= 1) {
            this.buffer.append(record.getMessage());
        } else {
            Object[] passedParams = Arrays.copyOfRange(params, 1, params.length);
            this.buffer.append(MessageFormat.format(record.getMessage(), passedParams));
        }
        if (this.lineEnds) {
            this.buffer.append(this.lineEnd);
        }
        return this.buffer.toString();
    }
}

