/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.io.Serializable;
import math.geom2d.Vector2D;

public class PolarVector2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double rho;
    protected double theta;

    public PolarVector2D(double rho, double theta) {
        this.rho = rho;
        this.theta = PolarVector2D.normalizeTheta(theta);
    }

    public double getRho() {
        return this.rho;
    }

    public double getTheta() {
        return this.theta;
    }

    Vector2D asCartesian() {
        return Vector2D.createPolar(this.rho, this.theta);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolarVector2D)) {
            return false;
        }
        PolarVector2D v = (PolarVector2D)obj;
        return Math.abs(v.getRho() - this.rho) < 1.0E-12 && PolarVector2D.normalizeTheta(v.getTheta() - this.theta) < 1.0E-12;
    }

    public static double normalizeTheta(double theta) {
        double retval = theta % (Math.PI * 2);
        if (retval < 0.0) {
            retval += Math.PI * 2;
        }
        return retval;
    }
}

