/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.line;

import java.util.ArrayList;
import java.util.Collection;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.curve.ContinuousCurve3D;
import math.geom3d.curve.Curve3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.transform.AffineTransform3D;

public class LineSegment3D
implements ContinuousCurve3D {
    private static final long serialVersionUID = 1L;
    protected Point3D firstPoint;
    protected Point3D lastPoint;

    public LineSegment3D(Point3D p1, Point3D p2) {
        this.firstPoint = p1;
        this.lastPoint = p2;
    }

    public StraightLine3D getSupportingLine() {
        return new StraightLine3D(this.firstPoint, this.lastPoint);
    }

    public Point3D projectPoint(Point3D point) {
        return this.getPoint(this.project(point));
    }

    public Collection<LineSegment3D> getContinuousCurves() {
        ArrayList<LineSegment3D> array = new ArrayList<LineSegment3D>(1);
        array.add(this);
        return array;
    }

    @Override
    public Point3D getFirstPoint() {
        return this.firstPoint;
    }

    @Override
    public Point3D getLastPoint() {
        return this.lastPoint;
    }

    @Override
    public Point3D getPoint(double t) {
        return new Point3D(this.firstPoint.getX() + (this.firstPoint.getX() - this.lastPoint.getX()) * t, this.firstPoint.getY() + (this.firstPoint.getY() - this.lastPoint.getY()) * t, this.firstPoint.getZ() + (this.firstPoint.getZ() - this.lastPoint.getZ()) * t);
    }

    @Override
    @Deprecated
    public Point3D getPoint(double t, Point3D point) {
        if (point == null) {
            point = new Point3D();
        }
        t = Math.max(Math.min(t, 1.0), 0.0);
        point.setLocation(this.firstPoint.getX() + (this.firstPoint.getX() - this.lastPoint.getX()) * t, this.firstPoint.getY() + (this.firstPoint.getY() - this.lastPoint.getY()) * t, this.firstPoint.getZ() + (this.firstPoint.getZ() - this.lastPoint.getZ()) * t);
        return point;
    }

    @Override
    public double getPosition(Point3D point) {
        double t = this.getSupportingLine().getPosition(point);
        if (t > 1.0) {
            return Double.NaN;
        }
        if (t < 0.0) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public Curve3D getReverseCurve() {
        return new StraightLine3D(this.getLastPoint(), this.getFirstPoint());
    }

    @Override
    public Collection<Point3D> getSingularPoints() {
        ArrayList<Point3D> points = new ArrayList<Point3D>(2);
        points.add(this.getFirstPoint());
        points.add(this.getLastPoint());
        return points;
    }

    @Override
    public LineSegment3D getSubCurve(double t0, double t1) {
        t0 = Math.max(t0, 0.0);
        t1 = Math.min(t1, 1.0);
        return new LineSegment3D(this.getPoint(t0), this.getPoint(t1));
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return 1.0;
    }

    @Override
    public double project(Point3D point) {
        double t = this.getSupportingLine().project(point);
        return Math.min(Math.max(t, 0.0), 1.0);
    }

    @Override
    public Curve3D transform(AffineTransform3D trans) {
        return new LineSegment3D(this.firstPoint.transform(trans), this.lastPoint.transform(trans));
    }

    @Override
    public Shape3D clip(Box3D box) {
        return null;
    }

    @Override
    public boolean contains(Point3D point) {
        StraightLine3D line = this.getSupportingLine();
        if (!line.contains(point)) {
            return false;
        }
        double t = line.getPosition(point);
        if (t < -1.0E-12) {
            return false;
        }
        return !(t > 1.000000000001);
    }

    @Override
    public Box3D getBoundingBox() {
        return new Box3D(this.firstPoint.getX(), this.lastPoint.getX(), this.firstPoint.getY(), this.lastPoint.getY(), this.firstPoint.getZ(), this.lastPoint.getZ());
    }

    @Override
    public double getDistance(Point3D point) {
        double t = this.project(point);
        return this.getPoint(t).getDistance(point);
    }

    public double getDistance(LineSegment3D segment) {
        double tN;
        double sN;
        double D;
        LineSegment3D thisSegment = this;
        Vector3D u = new Vector3D(thisSegment.getFirstPoint(), thisSegment.getLastPoint());
        Vector3D v = new Vector3D(segment.getFirstPoint(), segment.getLastPoint());
        Vector3D w = new Vector3D(segment.getFirstPoint(), thisSegment.getFirstPoint());
        double a = Vector3D.dotProduct(u, u);
        double b = Vector3D.dotProduct(u, v);
        double c = Vector3D.dotProduct(v, v);
        double d = Vector3D.dotProduct(u, w);
        double e = Vector3D.dotProduct(v, w);
        double sD = D = a * c - b * b;
        double tD = D;
        if (D < 1.0E-8) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
                sN = 0.0;
                tN = e;
                tD = c;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
            }
        }
        if (tN < 0.0) {
            tN = 0.0;
            if (-d < 0.0) {
                sN = 0.0;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if (-d + b < 0.0) {
                sN = 0.0;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        double sc = Math.abs(sN) < 1.0E-8 ? 0.0 : sN / sD;
        double tc = Math.abs(tN) < 1.0E-8 ? 0.0 : tN / tD;
        Vector3D dP = w.plus(u.times(sc).minus(v.times(tc)));
        return dP.getLength();
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public double getLength() {
        return this.getFirstPoint().getDistance(this.getLastPoint());
    }
}

