/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private XSLStylesheet stylesheet;
    private boolean overriding;

    public StylesheetFunctionLibrary(XSLStylesheet sheet, boolean overriding) {
        this.stylesheet = sheet;
        this.overriding = overriding;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        XSLFunction fn = this.stylesheet.getStylesheetFunction(functionName, arity);
        return fn != null;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        XSLFunction fn = this.stylesheet.getStylesheetFunction(functionName, staticArgs.length);
        if (fn == null) {
            return null;
        }
        if (fn.isOverriding() != this.overriding) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fn.registerReference(fc);
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setConfirmed(true);
        return fc;
    }

    public FunctionLibrary copy() {
        return this;
    }

    public List getAllFunctions() {
        return this.stylesheet.getAllStylesheetFunctions();
    }
}

