/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.MapPathsEvaluationTask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class MapPathsResult {
    private LogCategory log;
    private String mapName;
    private MapPathsEvaluationTask.PathType pathType;
    private int totalCount;
    private int builtCount;
    private MapPathsEvaluationTask task = null;

    public MapPathsResult(MapPathsEvaluationTask task, LogCategory log) {
        this.task = task;
        this.mapName = task.getMapName();
        this.pathType = task.getPathType();
        this.log = log;
    }

    public void addSuccessful() {
        ++this.builtCount;
        ++this.totalCount;
    }

    public void addFailed() {
        ++this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        OutputStreamWriter fstream = null;
        try {
            String fileName;
            if (this.task.isBatchTask()) {
                fileName = String.format("data_%d_%s.csv", this.task.getBatchNumber(), this.pathType.name());
            } else {
                fileName = String.format("data_%s.csv", this.pathType.name());
                File file = new File(this.task.getResultPath() + fileName);
                int i = 0;
                while (file.exists()) {
                    fileName = String.format("data_%s_%d.csv", this.pathType.name(), ++i);
                    file = new File(this.task.getResultPath() + fileName);
                }
            }
            String fullFilePath = this.task.getResultPath() + fileName;
            File resultFile = new File(fullFilePath);
            resultFile.getParentFile().mkdirs();
            fstream = new FileWriter(resultFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("PathType;Total;Successful");
            out.newLine();
            out.write(String.format("%s;%s;%d;%d\n", this.mapName, this.pathType.name(), this.totalCount, this.builtCount));
            out.close();
        }
        catch (IOException ex) {
            this.log.warning(ex.getMessage());
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (IOException ex) {
                this.log.warning(ex.getMessage());
            }
        }
    }
}

