/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import com.google.common.io.Files;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.MapInfo;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.SingleNavigationTaskEvaluator;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTaskFactory;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.zip.ZipUtil;

public abstract class SingleTaskEvaluatorBase {
    protected static final Logger log = Logger.getLogger("TaskEvaluator");
    private static final boolean REDIRECT_LOG = true;

    public static void main(String[] args) {
        log.setLevel(Level.ALL);
        log.fine("Running SingleTaskEvaluator");
        IEvaluationTask task = EvaluationTaskFactory.build(args);
        boolean isResume = args.length >= 2 && args[1].equals("--resume");
        String label = null;
        if (args.length > 2) {
            label = args[2];
        } else if (args.length == 2 && !isResume) {
            label = args[1];
        }
        task.setResultBasePath(ServerRunner.getStatsBasePath());
        File taskFile = new File(args[0]);
        File taskDefFile = new File(task.getResultPath(), taskFile.getName());
        try {
            taskDefFile.delete();
            Files.copy((File)taskFile, (File)taskDefFile);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        log.fine("Task built from args");
        SingleNavigationTaskEvaluator evaluator = new SingleNavigationTaskEvaluator();
        int result = evaluator.execute(task, isResume, label);
        System.exit(result);
    }

    public static UCCWrapper run(String mapName) {
        log.fine("UCC server starting...");
        UCCWrapperConf conf = new UCCWrapperConf();
        conf.setUnrealHome(ServerRunner.getUnrealHome());
        conf.setStartOnUnusedPort(true);
        String gameType = MapInfo.getGameType(mapName);
        conf.setGameType(gameType);
        conf.setMapName(mapName);
        UCCWrapper server = new UCCWrapper(conf);
        server.getLogger().setLevel(Level.WARNING);
        log.fine("UCC server started.");
        return server;
    }

    protected void setupLog(String logPath) {
        if (logPath == null) {
            return;
        }
        try {
            System.setOut(new PrintStream(logPath));
        }
        catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, null, ex);
        }
    }

    public abstract int execute(IEvaluationTask var1);

    protected void processResult(IEvaluationTask task) {
        String resultPath = task.getResultPath();
        if (ServerRunner.doCompress()) {
            String zipName = resultPath.substring(0, resultPath.length() - 2) + ".zip";
            ZipUtil.pack((File)new File(resultPath), (File)new File(zipName));
            if (ServerRunner.doDelete()) {
                try {
                    FileUtils.deleteDirectory((File)new File(resultPath));
                }
                catch (IOException ex) {
                    Logger.getLogger(SingleTaskEvaluatorBase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

