/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.io;

import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class FileSpanningOutputStream
extends OutputStream {
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long DEFAULT_VOLUME_SIZE = 650000000L;
    public static final long DEFAULT_ADDITIONAL_FIRST_VOLUME_FREE_SPACE_SIZE = 0L;
    protected static final String DEFAULT_VOLUME_NAME = "rdpack";
    protected static final long FILE_NOT_AVAILABLE = -1L;
    protected long maxvolumesize = 650000000L;
    protected long firstvolumefreespacesize = 0L;
    public static final String VOLUMES_INFO = "/volumes.info";
    public static final int MAGIC_NUMER_LENGTH = 10;
    protected File currentfile;
    protected String volumename;
    protected int currentvolumeindex;
    private FileOutputStream fileoutputstream;
    private GZIPOutputStream zippedoutputstream;
    private byte[] magicnumber;
    protected long filepointer;
    protected long totalbytesofpreviousvolumes;

    public FileSpanningOutputStream(String string, long l) throws IOException {
        this(new File(string), l);
    }

    public FileSpanningOutputStream(File file, long l) throws IOException {
        this(file, l, 0);
    }

    protected FileSpanningOutputStream(File file, long l, int n) throws IOException {
        this.generateMagicNumber();
        this.createVolumeOutputStream(file, l, n);
    }

    private void generateMagicNumber() {
        if (this.magicnumber == null) {
            this.magicnumber = new byte[10];
            Date date = new Date();
            long l = date.getTime();
            Random random = new Random(l);
            random.nextBytes(this.magicnumber);
            Debug.trace("created new magic number for FileOutputstream: " + new String(this.magicnumber));
            for (int i = 0; i < this.magicnumber.length; ++i) {
                Debug.trace(i + " - " + this.magicnumber[i]);
            }
        }
    }

    private void createVolumeOutputStream(File file, long l, int n) throws IOException {
        this.fileoutputstream = new FileOutputStream(file);
        this.zippedoutputstream = new GZIPOutputStream((OutputStream)this.fileoutputstream, 256);
        this.currentfile = file;
        this.currentvolumeindex = n;
        this.maxvolumesize = l;
        String string = "." + n;
        String string2 = file.getAbsolutePath();
        this.volumename = string2.endsWith(string) ? string2.substring(0, string2.indexOf(string)) : string2;
        long l2 = this.filepointer;
        this.write(this.magicnumber);
        this.filepointer = l2;
    }

    public FileSpanningOutputStream(File file) throws IOException {
        this(file.getAbsolutePath(), 650000000L);
    }

    public FileSpanningOutputStream(String string) throws IOException {
        this(string, 650000000L);
    }

    public FileSpanningOutputStream() throws IOException {
        this(DEFAULT_VOLUME_NAME, 650000000L);
    }

    protected long getCurrentVolumeSize() {
        if (this.currentfile == null) {
            return -1L;
        }
        try {
            this.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.currentfile = new File(this.currentfile.getAbsolutePath());
        if (this.currentvolumeindex == 0) {
            return this.currentfile.length() + this.firstvolumefreespacesize + Math.round(0.001 * (double)this.currentfile.length());
        }
        return this.currentfile.length() + Math.round(0.001 * (double)this.currentfile.length());
    }

    protected void createStreamToNextVolume() throws IOException {
        this.close();
        this.totalbytesofpreviousvolumes = this.currentfile.length();
        ++this.currentvolumeindex;
        String string = this.volumename + "." + this.currentvolumeindex;
        this.createVolumeOutputStream(new File(string), this.maxvolumesize, this.currentvolumeindex);
    }

    public void close() throws IOException {
        this.flush();
        this.zippedoutputstream.close();
        this.fileoutputstream.close();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if ((long)n2 > this.maxvolumesize) {
            throw new IOException("file can't be written. buffer length exceeded maxvolumesize ( > " + this.maxvolumesize + ")");
        }
        long l = this.getCurrentVolumeSize();
        long l2 = this.maxvolumesize - l;
        if (l2 < (long)n2) {
            Debug.trace("Not enough space left on volume. available: " + l2);
            Debug.trace("current size is: " + l);
            this.createStreamToNextVolume();
        }
        this.zippedoutputstream.write(byArray, n, n2);
        this.filepointer += (long)n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        long l = this.maxvolumesize - this.getCurrentVolumeSize();
        if (l >= 1L) {
            this.zippedoutputstream.write(n);
            ++this.filepointer;
        } else {
            this.createStreamToNextVolume();
            this.zippedoutputstream.write(n);
            ++this.filepointer;
        }
    }

    public void flush() throws IOException {
        this.zippedoutputstream.flush();
        this.fileoutputstream.flush();
    }

    public int getVolumeCount() {
        return this.currentvolumeindex + 1;
    }

    public long getFirstvolumefreespacesize() {
        return this.firstvolumefreespacesize;
    }

    public void setFirstvolumefreespacesize(long l) {
        this.firstvolumefreespacesize = l;
    }

    public long getCompressedFilepointer() throws IOException {
        this.flush();
        return this.totalbytesofpreviousvolumes + this.currentfile.length();
    }

    public long getFilepointer() {
        return this.filepointer;
    }
}

