/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.build;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionRequest;
import org.codehaus.mojo.resolver.bod.build.BuildConfiguration;
import org.codehaus.mojo.resolver.bod.build.DependencyBuilder;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriteConfiguration;
import org.codehaus.mojo.resolver.bod.pom.rewrite.PomRewriter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyBuilder
implements DependencyBuilder {
    private Invoker invoker;
    PomRewriter rewriter;
    ArtifactFactory artifactFactory;

    public DefaultDependencyBuilder() {
    }

    public DefaultDependencyBuilder(Invoker invoker, PomRewriter rewriter, ArtifactFactory artifactFactory) {
        this.invoker = invoker;
        this.rewriter = rewriter;
        this.artifactFactory = artifactFactory;
    }

    @Override
    public void buildDependencies(List<MavenProject> dependencyProjects, Set<String> completedBuilds, BuildOnDemandResolutionRequest request) throws BuildOnDemandResolutionException {
        BuildConfiguration prototypeConfig;
        DefaultMessageHolder errors = new DefaultMessageHolder();
        PomRewriteConfiguration rewriteConfig = request.getPomRewriteConfiguration();
        if (rewriteConfig == null) {
            rewriteConfig = new PomRewriteConfiguration();
        }
        if ((prototypeConfig = request.getBuildPrototype()) == null) {
            prototypeConfig = new BuildConfiguration();
        }
        File projectsDirectory = request.getProjectsDirectory();
        ArtifactRepository localRepository = request.getLocalRepository();
        Iterator<MavenProject> it = dependencyProjects.iterator();
        while (it.hasNext()) {
            MavenProject dependencyProject = it.next();
            File projectDir = new File(projectsDirectory, dependencyProject.getArtifactId() + "-" + dependencyProject.getVersion());
            projectDir.mkdirs();
            BuildConfiguration config = prototypeConfig.copy();
            config.setBaseDirectory(projectDir);
            Artifact pomArtifact = this.artifactFactory.createProjectArtifact(dependencyProject.getGroupId(), dependencyProject.getArtifactId(), dependencyProject.getVersion());
            String relativePath = localRepository.pathOf(pomArtifact);
            File pomSourceFile = new File(localRepository.getBasedir(), relativePath);
            String pomFileName = config.getPomFileName();
            if (pomFileName == null) {
                pomFileName = "pom.xml";
            }
            File pomFile = new File(projectDir, pomFileName);
            try {
                FileUtils.copyFile((File)pomSourceFile, (File)pomFile);
            }
            catch (IOException e) {
                errors.addErrorMessage((CharSequence)("Failed to copy pom: " + pomSourceFile + " to: " + projectDir + ". Error: " + e.getMessage()));
            }
            this.rewriter.rewriteOnDisk(pomFile, rewriteConfig, (MessageHolder)errors);
            if (!this.buildProject(dependencyProject.getId(), projectDir, config, (MessageHolder)errors)) continue;
            String key = ArtifactUtils.versionlessKey((String)dependencyProject.getGroupId(), (String)dependencyProject.getArtifactId());
            completedBuilds.add(key);
            it.remove();
        }
        if (!errors.isEmpty()) {
            throw new BuildOnDemandResolutionException("While building missing dependencies:\n\n" + errors.render());
        }
    }

    protected boolean buildProject(String projectId, File projectDir, BuildConfiguration configuration, MessageHolder errors) {
        InvocationResult result;
        try {
            result = this.invoker.execute((InvocationRequest)configuration);
        }
        catch (MavenInvocationException e) {
            errors.addMessage((CharSequence)("Failed to build project: " + projectId), (Throwable)e);
            return false;
        }
        CommandLineException executionException = result.getExecutionException();
        if (executionException != null) {
            errors.addMessage((CharSequence)("Failed invoke Maven to build project: " + projectId), (Throwable)executionException);
            return false;
        }
        if (result.getExitCode() != 0) {
            errors.addMessage((CharSequence)("Build for project: " + projectId + " failed; returned exit code: " + result.getExitCode()));
            return false;
        }
        return true;
    }
}

