package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import org.apache.commons.collections15.Transformer;

/**
 * <p>
 * Transformer which current implementation can be changed by any transformer instance.
 * </p>
 * <p>
 * Standard usage is to give instance of this class to any object which needs transformer. After
 * that, programmer have always ability to change behavior of passed transformer by calling
 * {@link #setCurrentTransformer(Transformer)} method with some new implementation of transformer.
 * </p>
 * 
 * @author LuVar
 *
 * @param <E>
 */
public class TransformerChangeable<A, B> implements Transformer<A, B> {
    private Transformer<A, B> currentTransformer;

    public TransformerChangeable(Transformer<A, B> initialTransformer) {
	this.setCurrentTransformer(initialTransformer);
    }

    public void setCurrentTransformer(Transformer<A, B> currentTransformer) {
	this.currentTransformer = currentTransformer;
    }

    public Transformer<A, B> getCurrentTransformer() {
	return this.currentTransformer;
    }

    @Override
    public B transform(A input) {
	return this.getCurrentTransformer().transform(input);
    }
}
