package sk.stuba.fiit.pogamut.jungigation.transformers;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;

/**
 * <p>
 * Transformer for geting median travel time from edges. If time is NaN, than 10000 is returned as time. This
 * is when the edge doesnt have any measured value.
 * </p>
 *
 * @author LuVar
 */
public class EdgeToTimeNumberTransformer implements Transformer<MyEdge, Number> {
	public Number transform(MyEdge i) {
		double time = i.getTravelTime();
		if(Double.isNaN(time)) {
			time = 10000;
		}
		Number navrat = time;
		return navrat;
	}
}
