package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;

/**
 * <p>
 * Static version of {@link ProphetObjectVision} abstract class
 * </p>
 * 
 * @author LuVar
 *
 */
public abstract class ProbhetObjectVisionStatic {
	protected final UnrealId id;
	private double lastSeenTime = -10;
	protected Set<Map.Entry<Location, Double>> location;
	
	public ProbhetObjectVisionStatic(UnrealId id, Set<Map.Entry<Location, Double>> location) {
		this.id = id;
		this.setFuzzyLocation(location);
	}

	public UnrealId getId() {
		return this.id;
	}

	public double getLastSeenTime() {
		return this.lastSeenTime;
	}

	/**
	 * <p>
	 * Automatically notifies all listeners.
	 * </p>
	 * 
	 * @param lastSeenTime
	 */
	public void setLastSeenTime(double lastSeenTime) {
		this.lastSeenTime = lastSeenTime;
	}

	/**
	 * <p>
	 * Returned value is changing permanently, so you wont be notified about change of
	 * this value!
	 * </p>
	 * 
	 * @return
	 */
	public double getAge() {
		return GameTime.actualTime - this.lastSeenTime;
	}

	public Map.Entry<Location, Double> getMostProbableLocation() {
		double maximum = Double.MIN_VALUE;
		Map.Entry<Location, Double> mostProbableLocation = null;
		for (Map.Entry<Location, Double> loc : this.location) {
			if(loc.getValue() > maximum) {
				mostProbableLocation = loc;
				maximum = loc.getValue();
			}
		}
		//TODO pre-compute, lazy
		return mostProbableLocation;
	}

	/**
	 * <p>
	 * Returns unmodifiable set.
	 * </p>
	 * 
	 * @return
	 */
	public Set<Map.Entry<Location, Double>> getFuzzyLocation() {
		return Collections.unmodifiableSet(this.location);
	}

	/**
	 * <p>
	 * Automatically notifies all listeners.
	 * </p>
	 * 
	 * @param location
	 */
	public void setFuzzyLocation(Set<Map.Entry<Location, Double>> location) {
		if(location == null) {
			throw new RuntimeException("Location should not be null! " + this.getClass().getName());
		}
		if(location.size() == 0) {
			throw new RuntimeException("Location should not have size 0! " + this.getClass().getName());
		}
		this.location = location;
	}

}