/**
 * 
 */
package jung.myalghoritm.myGreedyShortestPath;

import java.util.LinkedList;

/**
 * @author LuVar
 * 
 */
public class ContextOfOneCrawler<V, E> {
    private V actualNode;
    private final LinkedList<E> visitedEdges;
    private double distanceTravlled = 0.0;
    private LinkedList<V> lastNodes;

    public ContextOfOneCrawler(V v) {
	this.actualNode = v;
	this.visitedEdges = new LinkedList<E>();
	this.lastNodes = new LinkedList<V>();
    }

    private ContextOfOneCrawler(LinkedList<E> ve) {
	this.visitedEdges = ve;
    }

    public V getActualNode() {
	return this.actualNode;
    }

    public LinkedList<E> getVisitedEdges() {
	return this.visitedEdges;
    }

    public double getDistanceTravlled() {
	return this.distanceTravlled;
    }

    public void addVisitedEdge(E e, V v, double distance) {
	this.visitedEdges.add(e);
	this.distanceTravlled += distance;
	this.actualNode = v;
	this.lastNodes.push(v);
	while (this.lastNodes.size() > 122) {
	    this.lastNodes.pop();
	}
    }

    /**
     * <p>
     * Will clone current instance and call {@link #addVisitedEdge(Object, double)} on clone, which will be returned.
     * </p>
     * 
     * @param e
     * @param distance
     * @return
     */
    public ContextOfOneCrawler<V, E> getNewFork(E e, V v, double distance) {
	ContextOfOneCrawler<V, E> navrat = new ContextOfOneCrawler<V, E>(new LinkedList<E>(this.visitedEdges));
	navrat.distanceTravlled = this.distanceTravlled;
	navrat.lastNodes = new LinkedList<V>(this.lastNodes);
	navrat.addVisitedEdge(e, v, distance);
	return navrat;
    }

    public boolean shouldGoThere(E thru, V target) {
	if (this.visitedEdges.contains(thru)) {
	    return false;
	}
	if (this.lastNodes.contains(target)) {
	    return false;
	}
	return true;
    }

    @Override
    public String toString() {
	String navrat = "Context:actNode=" + this.actualNode + ",time=" + this.distanceTravlled + ",count=" + this.visitedEdges.size();
	return navrat;
    }
}
