package sk.stuba.fiit.pogamut.jungigation.bot;

import java.util.Collection;
import java.util.Random;

import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;
import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionHistoryStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

/**
 * <p>
 * Most useful class. It is mean to be skeleton for bot using for navigation jungigation library. This abstract
 * class mainly provides {@link #botInitialized(GameInfo, ConfigChange, InitedMessage)} method which initializes
 * {@link #navigationGraph}, {@link #navpoints}, {@link #sd}, {@link #gameInfo} and {@link #pathExecutor}.
 * </p>
 * 
 * @author LuVar
 *
 */
@SuppressWarnings("unchecked")
public abstract class AbstractBotWithJungigation extends UT2004BotLogicController {
    /**
     * log4j logger.
     */
    protected Logger log = Logger.getLogger(AbstractBotWithJungigation.class);

    private final Random rnd = new Random();
    public NavigationGraphSynchronized navigationGraph;
    public Collection<NavPoint> navpoints;
    public UT2004PathExecutor<ILocated> pathExecutor;
    @JProp
    protected String mapName;

    /**
     * <p>
     * Stuck detector instance used to detect stuck like behavior.
     * </p>
     */
    protected IStuckDetector sd;
    protected GameInfo gameInfo = null;

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
	super.botInitialized(gameInfo, config, init);
	GameTime.startUpdatingTime(this.getWorldView());
	this.gameInfo = gameInfo;
	long startTime = System.currentTimeMillis();
	this.log.info("Going to get all NavPoints ftom world.");
	this.navpoints = this.bot.getWorldView().getAll(NavPoint.class).values();
	{
	    // String firstnavpointname = navpoints.iterator().next().getId().getStringId();
	    // int firstDot = firstnavpointname.indexOf(".");
	    // mapName = firstnavpointname.substring(0, firstDot);
	    this.mapName = this.gameInfo.getLevel();
	}
	this.navigationGraph = NavigationGraphProviderForMap.getInstance().getNavigationDataForMapWithChceckAndInitialization(this.mapName, this.navpoints);
	// TODO start learning map here, or in bot code? Now in bot code, in Iexplorer6 is line like this:
	// NavigationGraphProviderForMap.getInstance().startLearningMap(mapName);

	long endTime = System.currentTimeMillis();
	this.log.info("Navigation graph constructed in " + (endTime - startTime) + " ms.");
	this.log.info("Going to plan first random target.");
	// this.pathPlanner = new UTAstar(bot);
	this.pathExecutor = new UT2004PathExecutor<ILocated>(this.bot);

	this.sd = new UT2004PositionHistoryStuckDetector(this.bot);
	this.pathExecutor.addStuckDetector(this.sd);
    }

    /**
     * Randomly picks some navigation point and returns it.
     * 
     * @return randomly chosen navpoint
     */
    public NavPoint pickNewRandomNavTarget() {
	// 1. get all known navigation points
	Collection<NavPoint> navPoints = getWorldView().getAll(NavPoint.class).values();

	// 2. compute index of the target nav point
	int navPointIndex = this.rnd.nextInt(navPoints.size());

	// 3. find the corresponding nav point
	int i = 0;
	for (NavPoint nav : navPoints) {
	    if (i == navPointIndex) {
		return nav;
	    }
	    i++;
	}

	// 4. deal with unexpected behavior
	throw new RuntimeException("No navpoint chosen. There are no navpoints in the list of known navpoints");
    }// end of method pickNewRandomNavTarget

    public UT2004Bot getBot() {
	return this.bot;
    }
}
