package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.Collection;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Planner for everyday use, especially if you are in hurry getting somewhere.
 * </p>
 * <p>
 * This planner should use pre-computed run time times from {@link Iexplorer6} and computes fastest path to the target
 * by {@link SimplestDijkstraPathPlanner} class. Provide him good navigation graph from
 * {@link NavigationGraphProviderForMap} class.
 * </p>
 * 
 * @author LuVar
 */
public class PathPlannerTimeOptimized extends SimplestDijkstraPathPlanner {
    public PathPlannerTimeOptimized(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints) {
	super(g, bot, navpoints);
    }
}
