package sk.stuba.fiit.pogamut.jungigation.pathPlanners.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

public class EdgeToNumberAdvancedTransformer implements Transformer<MyEdge, Number> {
    private static final Logger log = Logger.getLogger(EdgeToNumberAdvancedTransformer.class);

    private Map<MyVertice, WeigthForItem> mapOfItemInterest;
    private final Graph<MyVertice, MyEdge> navigationGraph;

    public EdgeToNumberAdvancedTransformer(Graph<MyVertice, MyEdge> navigationGraph, Map<MyVertice, WeigthForItem> mapOfItemInterest) {
	this.mapOfItemInterest = mapOfItemInterest;
	this.navigationGraph = navigationGraph;
    }

    @Override
    public Number transform(MyEdge edge) {
	// default offset
	double navrat = 0.7;
	double travelTime = edge.getTravelTime();
	if (Double.isNaN(travelTime)) {
	    travelTime = 1000;
	}
	navrat += travelTime;
	// MyVertice endVertice = this.navigationGraph.getSource(edge);
	MyVertice endVertice = this.navigationGraph.getDest(edge);

	WeigthForItem weigthForItem = this.mapOfItemInterest.get(endVertice);
	if (weigthForItem != null) {
	    navrat -= weigthForItem.getOffsetAdd();
	    if (endVertice.getItemAmount() != -1) {
		navrat -= weigthForItem.getAmountMultiplier() * endVertice.getItemAmount();
	    }
	}
	// TODO tu by mal byt dostupny wordl prophet a mala by sa z neho tahat informacia o pravdepodobnosti, ze tam ta
	// itema je
	if (Double.isInfinite(navrat) || Double.isNaN(navrat)) {
	    log.warn("Edge had no number value! Edge: " + edge);
	}
	return navrat;
    }

    public void setNewMapInterest(Map<MyVertice, WeigthForItem> mapOfItemInterest) {
	this.mapOfItemInterest = mapOfItemInterest;
    }

    public static Map<MyVertice, WeigthForItem> getHealthInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph, Collection<NavPoint> navpoints) {
	Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
	Collection<MyVertice> vertices = navigationGraph.getVertices();
	for (MyVertice vertice : vertices) {
	    String itemType = vertice.getItemType();
	    if (itemType == null) {
		continue;
	    }
	    if (itemType.equals("XPickups.HealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.17f, 50f));
		continue;
	    }
	    if (itemType.equals("XPickups.MiniHealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.8f, 15f));
		continue;
	    }
	    if (itemType.equals("XPickups.AdrenalinePickup")) {
		navrat.put(vertice, new WeigthForItem(1f, 1f));
		continue;
	    }
	    if (itemType.equals("XPickups.SuperShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 19f));
		continue;
	    }
	    if (itemType.equals("XPickups.ShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 12f));
		continue;
	    }
	}// end of for navPoint in navpoints
	return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getJustTimeInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
	Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();
	return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getArmorInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
	Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();

	Collection<MyVertice> vertices = new ArrayList<MyVertice>(navigationGraph.getVertices());
	for (MyVertice vertice : vertices) {
	    String itemType = vertice.getItemType();
	    if (itemType == null) {
		continue;
	    }
	    if (vertice.getId().toString().toLowerCase().contains("pot101") || vertice.getId().toString().toLowerCase().contains("pot96")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 4f));
		continue;
	    }
	    if (itemType.equals("XPickups.HealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.17f, 1f));
		continue;
	    }
	    if (itemType.equals("XPickups.MiniHealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.8f, 2f));
		continue;
	    }
	    if (itemType.equals("XPickups.AdrenalinePickup")) {
		navrat.put(vertice, new WeigthForItem(1f, 1f));
		continue;
	    }
	    if (itemType.equals("XPickups.SuperShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 19f));
		continue;
	    }
	    if (itemType.equals("XPickups.ShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 12f));
		continue;
	    }

	    /*
	     * if (itemType.equals(ItemType.BIO_RIFLE_AMMO)) { navrat.put(vertice, new WeigthForItem(0.06f, 6000f));
	     * continue; }
	     */
	}// end of for vertice in vertices
	return navrat;
    }

    public static Map<MyVertice, WeigthForItem> getMachinegunInterestMapForNavpoints(Graph<MyVertice, MyEdge> navigationGraph) {
	Map<MyVertice, WeigthForItem> navrat = new HashMap<MyVertice, WeigthForItem>();

	Collection<MyVertice> vertices = new ArrayList<MyVertice>(navigationGraph.getVertices());
	for (MyVertice vertice : vertices) {
	    String itemType = vertice.getItemType();
	    if (itemType == null) {
		continue;
	    }
	    if (itemType.equals("XPickups.HealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.17f, 1f));
		continue;
	    }
	    if (itemType.equals("XPickups.MiniHealthPack")) {
		navrat.put(vertice, new WeigthForItem(0.8f, 2f));
		continue;
	    }
	    if (itemType.equals("XPickups.AdrenalinePickup")) {
		navrat.put(vertice, new WeigthForItem(1f, 1f));
		continue;
	    }
	    if (itemType.equals("XPickups.SuperShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 19f));
		continue;
	    }
	    if (itemType.equals("XPickups.ShieldPack")) {
		navrat.put(vertice, new WeigthForItem(0.1f, 12f));
		continue;
	    }

	    /*
	     * if (itemType.equals(ItemType.BIO_RIFLE_AMMO)) { navrat.put(vertice, new WeigthForItem(0.06f, 6000f));
	     * continue; }
	     */
	}// end of for vertice in vertices
	return navrat;
    }
}
