/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;

/**
 * <p>
 * This should be common object for getting time.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class GameTime implements IWorldEventListener<BeginMessage> {
    public static double actualTime = -11;

    private static GameTime singleton = null;

    private GameTime() {
    }

    /**
     * <p>
     * Registers for receiving time on ALL {@link IWorldView} instances given in all calls!
     * </p>
     * 
     * @param worldView {@link IWorldView} for registering to receiving {@link BeginMessage} event
     * @return true, if method registered to given {@link IWorldView} instance, false otherwise
     * 
     *         <p>
     *         NOTE: This method always returns true.
     *         </p>
     */
    public static boolean forceStartUpdatingTime(IWorldView worldView) {
	if (GameTime.singleton != null) {
	    worldView.addEventListener(BeginMessage.class, GameTime.singleton);
	    return true;
	}
	GameTime.singleton = new GameTime();
	worldView.addEventListener(BeginMessage.class, GameTime.singleton);
	return true;
    }

    /**
     * <p>
     * Registers for receiving time only if first instance on private singleton is begin created.
     * </p>
     * 
     * @param worldView {@link IWorldView} for registering to receiving {@link BeginMessage} event
     * @return true, if method registered to given {@link IWorldView} instance, false otherwise
     */
    public static boolean startUpdatingTime(IWorldView worldView) {
	if (GameTime.singleton != null) {
	    return false;
	}
	GameTime.singleton = new GameTime();
	worldView.addEventListener(BeginMessage.class, GameTime.singleton);
	return true;
    }

    @Override
    public void notify(BeginMessage event) {
	GameTime.actualTime = event.getTime();
    }
}
