package sk.stuba.fiit.pogamut.jungigation.worldInfo;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;

/**
 * Interface that allows you to define "usefulness of items".
 * <p><p>
 * Used by {@link AdvancedSharedItems}.
 * 
 * @author Jimmy
 */
public interface IUsefulItemFilter {

	/**
	 * Tells whether the item is useful to the bot.
	 * @param advancedItems
	 * @param item
	 * @param usefulness degree of usefulness, 0 - return also useless, 1 - return only <b>really truly</b> useful items which are MUST HAVE!
	 * @return usefulness of 'item'
	 */
	public boolean isItemUseful(AdvancedSharedItems advancedItems, Item item, double usefulness);

}
