/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.AdvancedSharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.SharedItems;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.WorldProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.ItemSnapshoot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AdvancedItems;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;

/**
 * <p>
 * Lowest class in hierarchy of {@link WorldProphet} related classes.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class ItemsCache implements CacheInterface {
	private Map<IWorldView, ItemsListener> listeners = new HashMap<IWorldView, ItemsListener>();
	private Map<UnrealId, List<ItemSnapshoot>> itemsHistory = Collections.synchronizedMap(new HashMap<UnrealId, List<ItemSnapshoot>>());
	
	public static final int HISTORYSIZE = 10;
	
	/**
	 * <p>
	 * For similar functionality look in see section.
	 * </p>
	 * 
	 * @param worldView
	 * 
	 * @see FlagsCache
	 * @see PlayersCache
	 * @see SharedItems
	 * @see AdvancedSharedItems
	 * @see Items
	 * @see AdvancedItems
	 */
	public ItemsCache(IWorldView worldView) {
		ItemsListener tmp = new ItemsListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(Item.class, tmp);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#addAnotherViewer(cz.cuni.amis.pogamut
	 * .base.communication.worldview.IWorldView)
	 */
	public void addAnotherViewer(IWorldView worldView) {
		ItemsListener tmp = new ItemsListener();
		this.listeners.put(worldView, tmp);
		worldView.addObjectListener(Item.class, WorldObjectUpdatedEvent.class, tmp);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * sk.stuba.fiit.LuVar.pogamut.jungigation.worldInfo.objectsCache.CacheInterface#removeViewer(cz.cuni.amis.pogamut
	 * .base.communication.worldview.IWorldView)
	 */
	public void removeViewer(IWorldView worldView) {
		ItemsListener tmp = this.listeners.get(worldView);
		this.listeners.remove(worldView);
		worldView.removeObjectListener(Item.class, WorldObjectUpdatedEvent.class, tmp);
	}
	
	/**
	 * <p>
	 * Returns list of last known states for desired item. Returned list is unmodifiable.
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<ItemSnapshoot> getItemHistory(UnrealId id) {
		return Collections.unmodifiableList(this.itemsHistory.get(id));
	}
	
	/**
	 * <p>
	 * Whole items history. Unmodifiable.
	 * </p>
	 * 
	 * @return
	 */
	public Map<UnrealId, List<ItemSnapshoot>> getItemsHistory() {
		return Collections.unmodifiableMap(this.itemsHistory);
	}
	
	protected void notify(Item event) {
		List<ItemSnapshoot> oneItemHistory = this.itemsHistory.get(event.getId());
		if (oneItemHistory == null) {
			// TODO choose best implementation of list or code own, synchronized
			oneItemHistory = Collections.synchronizedList(new LinkedList<ItemSnapshoot>());
			this.itemsHistory.put(event.getId(), oneItemHistory);
		}// end of if itemHistory == null
		oneItemHistory.add(0, new ItemSnapshoot(event));
		// keep just last 10 item states
		while (oneItemHistory.size() > ItemsCache.HISTORYSIZE) {
			oneItemHistory.remove(ItemsCache.HISTORYSIZE);
		}
	}
	
	private class ItemsListener implements IWorldObjectListener<Item> {
		@Override
		public void notify(IWorldObjectEvent<Item> event) {
			ItemsCache.this.notify(event.getObject());
		}// end of method notify
	}// end of private class ItemsCache
}
