package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.AbstractMap.SimpleImmutableEntry;
import java.util.Map.Entry;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleFlagInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.FlagsCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.FlagSnapshoot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;

public class FlagsProphet extends FlagsCache {
	private FlagInfo redFlag = null;
	private FlagInfo blueFlag = null;
	private FlagInfo enemyFlag = null;
	private FlagInfo myFlag = null;
	private final int team;
	private final GameInfo gameInfo;
	private final GamersProphet gamersProphet;
	
	private final Collection<FlagInfo> flags;
	
	public FlagsProphet(IWorldView worldView, int team, GameInfo gameInfo, GamersProphet gamersProphet) {
		super(worldView);
		this.team = team;
		this.gameInfo = gameInfo;
		this.gamersProphet = gamersProphet;
		this.flags = worldView.getAll(FlagInfo.class).values();
	}
	
	protected FlagInfo getRedFlag() {
		if (this.redFlag == null) {
			for (FlagInfo flag : this.flags) {
				if (flag.getTeam() == AgentInfo.TEAM_RED) {
					this.redFlag = flag;
					break;
				}
			}// end of foreach flag in flags
			if (this.redFlag == null) {
				throw new RuntimeException("Red flag not found!");
			}
		}
		return this.redFlag;
	}
	
	protected FlagInfo getBlueFlag() {
		if (this.blueFlag == null) {
			for (FlagInfo flag : this.flags) {
				if (flag.getTeam() == AgentInfo.TEAM_BLUE) {
					this.blueFlag = flag;
					break;
				}
			}// end of foreach flag in flags
			if (this.blueFlag == null) {
				throw new RuntimeException("Blue flag not found!");
			}
		}
		return this.blueFlag;
	}
	
	protected FlagInfo getEnemyFlag() {
		if (this.enemyFlag == null) {
			switch (this.team) {
			case AgentInfo.TEAM_RED:
				this.enemyFlag = this.getBlueFlag();
				break;
			case AgentInfo.TEAM_BLUE:
				this.enemyFlag = this.getRedFlag();
				break;
			default:
				throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
			}
		}
		return this.enemyFlag;
	}// end of method getEnemyFlag
	
	protected FlagInfo getMyFlag() {
		if (this.myFlag == null) {
			switch (this.team) {
			case AgentInfo.TEAM_RED:
				this.myFlag = this.getRedFlag();
				break;
			case AgentInfo.TEAM_BLUE:
				this.myFlag = this.getBlueFlag();
				break;
			default:
				throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
			}
		}
		return this.myFlag;
	}// end of method getMyFlag
	
	private SimpleFlagInfo enemySimpleFlag = null;
	private SimpleFlagInfo mySimpleFlag = null;
	
	/**
	 * <p>
	 * Returns instance of {@link SimpleFlagInfo}. This instance will be singleton in context of this
	 * {@link FlagsProphet} instance. So you need acquire simple flag info only once and than just receive its event
	 * about update and check new attribute values in that instance.
	 * </p>
	 * 
	 * @return
	 * 
	 * @see #getMySimpleFlag()
	 */
	public SimpleFlagInfo getEnemySimpleFlag() {
		if (this.enemySimpleFlag == null) {
			FlagInfo enemyF = this.getEnemyFlag();
			Set<Entry<Location, Double>> location = new HashSet<Entry<Location, Double>>();
			if (enemyF.getLocation() == null) {
				// TODO na zaklade historie urcit polohu
				switch (this.team) {
				case AgentInfo.TEAM_RED:
					location.add(new SimpleImmutableEntry<Location, Double>(this.gameInfo.getBlueBaseLocation(), 0.9));
					break;
				case AgentInfo.TEAM_BLUE:
					location.add(new SimpleImmutableEntry<Location, Double>(this.gameInfo.getRedBaseLocation(), 0.9));
					break;
				default:
					throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
				}
			} else {// end of if enemyF.getLocation() == null
				// TODO na zaklade historie urcit polohu
				location.add(new SimpleImmutableEntry<Location, Double>(enemyF.getLocation(), 1.0));
			}// end of else if enemyF.getLocation() == null
			this.enemySimpleFlag = new SimpleFlagInfo(enemyF.getId(), location);
		}// end of if enemySimpleFlag == null
		return this.enemySimpleFlag;
	}
	
	/**
	 * <p>
	 * See javadoc on {@link #getEnemySimpleFlag()} method.
	 * </p>
	 * 
	 * @return
	 * 
	 * @see #getEnemySimpleFlag()
	 */
	public SimpleFlagInfo getMySimpleFlag() {
		if (this.mySimpleFlag == null) {
			FlagInfo myF = this.getMyFlag();
			Set<Entry<Location, Double>> location = new HashSet<Entry<Location, Double>>();
			if (myF.getLocation() == null) {
				switch (this.team) {
				case AgentInfo.TEAM_RED:
					location.add(new SimpleImmutableEntry<Location, Double>(this.gameInfo.getRedBaseLocation(), 0.9));
					break;
				case AgentInfo.TEAM_BLUE:
					location.add(new SimpleImmutableEntry<Location, Double>(this.gameInfo.getBlueBaseLocation(), 0.9));
					break;
				default:
					throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
				}
			} else {
				location.add(new SimpleImmutableEntry<Location, Double>(myF.getLocation(), 1.0));
			}
			this.mySimpleFlag = new SimpleFlagInfo(myF.getId(), location);
		}
		return this.mySimpleFlag;
	}
	
	protected Location getHomeLocationForBlue() {
		return this.gameInfo.getBlueBaseLocation();
	}
	
	protected Location getHomeLocationForRed() {
		return this.gameInfo.getRedBaseLocation();
	}
	
	public Location getHomeLocationForEnemy() {
		switch (this.team) {
		case AgentInfo.TEAM_RED:
			return this.getHomeLocationForBlue();
		case AgentInfo.TEAM_BLUE:
			return this.getHomeLocationForRed();
		default:
			throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
		}
	}
	
	public Location getHomeLocationForMy() {
		switch (this.team) {
		case AgentInfo.TEAM_RED:
			return this.getHomeLocationForRed();
		case AgentInfo.TEAM_BLUE:
			return this.getHomeLocationForBlue();
		default:
			throw new RuntimeException("I am not in red nor in blue team! My team is: " + this.team);
		}
	}
	
	/**
	 * TODO zacat nejako hendlovat spravu o tom, ze mi dakto kradne vlajku, ale nevidim ho! Ukazkova sprava tohoto typu:
	 * FlagInfo!!! InfoMessage[FlagInfo] | Id = WorldObjectId[CTF-LostFaith.xBlueFlag] | Location = null | Holder = null
	 * | Team = 1 | Reachable = false | Visible = false | State = Held |
	 */
	@Override
	protected void notify(FlagInfo event) {
		super.notify(event);
		UnrealId holderId = event.getHolder();
		List<FlagSnapshoot> history = this.getFlagHistory(event.getId());
		double lastSeen = event.getSimTime();
		Location flagHomeLocation = null;
		if (event.equals(this.getMyFlag())) {
			flagHomeLocation = this.getHomeLocationForMy();
		} else {
			if (event.equals(this.getEnemyFlag())) {
				flagHomeLocation = this.getHomeLocationForEnemy();
			} else {
				throw new RuntimeException("Unknown flag info! That flag is not my nor enemy! Flagevent:" + event);
			}
		}// end of if else if it is my flag
		
		Set<Entry<Location, Double>> location = new HashSet<Entry<Location, Double>>();
		{
			double probability = history.get(0).getAge() / 30;
			if (probability > 1.0) {
				location.add(new SimpleImmutableEntry(flagHomeLocation, 0.9));
			} else {
				probability = 1 - probability;
				// TODO odhad spravit nejako normalne a nie last position
				Location loc = null;
				int i = 0;
				while (loc == null && i < history.size()) {
					loc = history.get(i++).getLocation();
				}
				if (loc == null) {
					location.add(new SimpleImmutableEntry(flagHomeLocation, 0.9));
				} else {
					location.add(new SimpleImmutableEntry(loc, probability));
				}
			}
		}// end of block for filing location
		
		if (event.equals(this.getMyFlag())) {
			this.getMySimpleFlag().setHolder(holderId);
			this.mySimpleFlag.setLastSeenTime(lastSeen);
			this.mySimpleFlag.setFuzzyLocation(location);
		} else {
			if (event.equals(this.getEnemyFlag())) {
				this.getEnemySimpleFlag().setHolder(holderId);
				this.enemySimpleFlag.setLastSeenTime(lastSeen);
				this.enemySimpleFlag.setFuzzyLocation(location);
			} else {
				throw new RuntimeException("Unknown flag info! That flag is not my nor enemy! Flagevent:" + event);
			}
		}// end of if else if it is my flag
	}// end of method notify
}
