/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.objects;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.GraphMLReader2;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jung.myio.GraphMLWriter2;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeMetadataTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.GraphMetadataTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.HyperEdgeMetadataTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.MetadataEdgeTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.MetadataGraphTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.MetadataNodeTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.NodeMetadataTransformer;

public class NavigationGraphProviderForMap {
    private static NavigationGraphProviderForMap singleton = null;
    private static final Logger log = Logger.getLogger(NavigationGraphSynchronized.class);
    private final String directoryWithGMLFiles;
    private final Map<String, NavigationGraphSynchronized> cache = Collections.synchronizedMap(new HashMap());

    public NavigationGraphProviderForMap(String directoryWithGMLFiles) {
        this.directoryWithGMLFiles = new File(directoryWithGMLFiles).getPath() + File.separator;
    }

    public static NavigationGraphProviderForMap getInstance() {
        if (singleton == null) {
            singleton = new NavigationGraphProviderForMap("./");
        }
        return singleton;
    }

    public NavigationGraphSynchronized getNavigationDataForMapWithChceckAndInitialization(String mapName, Collection<NavPoint> navpoints) {
        NavigationGraphSynchronized g = this.cache.get(mapName);
        if (g == null) {
            g = NavigationGraphProviderForMap.getGraphFromNavPoints(navpoints);
            g = NavigationGraphProviderForMap.getGraphFromFileAndCompare(this.mapNameToFilename(mapName), g);
            this.cache.put(mapName, g);
        }
        return g;
    }

    public NavigationGraphSynchronized getNavigationDataForMap(String mapName) {
        NavigationGraphSynchronized g = this.cache.get(mapName);
        if (g == null) {
            try {
                g = NavigationGraphProviderForMap.getGraphFromFile(this.mapNameToFilename(mapName));
            }
            catch (Exception ex) {
                throw new RuntimeException("Map graph not found in cache nor on disk! Use getNavigationDataForMapWithChceckAndInitialization method first!");
            }
            if (g == null) {
                throw new RuntimeException("Map graph not found in cache nor on disk! Use getNavigationDataForMapWithChceckAndInitialization method first!");
            }
        }
        return g;
    }

    private String mapNameToFilename(String mapName) {
        return this.directoryWithGMLFiles + mapName + ".graphML";
    }

    public boolean checkCompatibility(String mapName, Collection<NavPoint> navpoints) {
        return NavigationGraphProviderForMap.checkCompatibilityWithFile(this.mapNameToFilename(mapName), navpoints);
    }

    public static boolean checkCompatibilityWithFile(String filename, Collection<NavPoint> navpoints) {
        NavigationGraphSynchronized g = NavigationGraphProviderForMap.getGraphFromNavPoints(navpoints);
        NavigationGraphSynchronized gF = NavigationGraphProviderForMap.getGraphFromFile(filename);
        return gF.getVertices().containsAll(g.getVertices()) && g.getVertices().containsAll(gF.getVertices());
    }

    public static NavigationGraphSynchronized getGraphFromFileAndCompare(String filename, NavigationGraphSynchronized g) {
        NavigationGraphSynchronized gF;
        try {
            gF = NavigationGraphProviderForMap.getGraphFromFile(filename);
        }
        catch (Exception ex) {
            log.info((Object)("Could not load file " + filename + "! Using navigation graph from game. Error: " + ex.getMessage()));
            return g;
        }
        Collection gFvertices = gF.getVertices();
        Collection gvertices = g.getVertices();
        if (gFvertices.containsAll(gvertices) && gvertices.containsAll(gFvertices)) {
            log.info((Object)"Saved graph in file was same as generated from game.");
            return gF;
        }
        LinkedList gfv = new LinkedList(gFvertices);
        Collections.sort(gfv);
        LinkedList gv = new LinkedList(gvertices);
        Collections.sort(gv);
        System.out.println("FILE VERTICES:");
        for (MyVertice myVertice : gfv) {
            System.out.println(myVertice);
        }
        System.out.println("GAME VERTICES:");
        for (MyVertice myVertice : gv) {
            System.out.println(myVertice);
        }
        log.error((Object)"Saved graph was not same as graph generated from game!");
        return g;
    }

    public static NavigationGraphSynchronized getGraphFromNavPoints(Collection<NavPoint> navpoints) {
        NavigationGraphSynchronized g = new NavigationGraphSynchronized(0.0, 0L, 0L);
        for (NavPoint navPoint : navpoints) {
            MyVertice from = new MyVertice(navPoint);
            g.addVertex(from);
            Collection neighobur = navPoint.getOutgoingEdges().values();
            for (NavPointNeighbourLink navPointNeighbourLink : neighobur) {
                MyVertice to = new MyVertice(navPointNeighbourLink.getToNavPoint());
                g.addEdge(new MyEdge(from.getId().getStringId() + "->" + to.getId().getStringId()), from, to, EdgeType.DIRECTED);
            }
        }
        return g;
    }

    public static NavigationGraphSynchronized getGraphFromFile(String filename) {
        NavigationGraphSynchronized graphFromFile;
        GraphMLReader2 gr;
        try {
            gr = new GraphMLReader2((Reader)new FileReader(filename), (Transformer)new GraphMetadataTransformer(), (Transformer)new NodeMetadataTransformer(), (Transformer)new EdgeMetadataTransformer(), (Transformer)new HyperEdgeMetadataTransformer());
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found! file=\"" + filename + "\". Error:" + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while opening graph file. file=\"" + filename + "\"! file=\"" + filename + "\". Error:" + ex.getMessage(), ex);
        }
        try {
            graphFromFile = (NavigationGraphSynchronized)gr.readGraph();
        }
        catch (GraphIOException ex) {
            throw new RuntimeException("GraphIOException while reading graph! file=\"" + filename + "\". Error:" + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while reading graph from file. file=\"" + filename + "\"! file=\"" + filename + "\". Error:" + ex.getMessage(), ex);
        }
        return graphFromFile;
    }

    public void startLearningMap(String mapName) {
        if (this.cache.get(mapName) == null) {
            throw new RuntimeException("Cant start saving map, if map is not initialized. Use getNavigationDataForMapWithChceckAndInitialization method first!");
        }
        NavigationGraphProviderForMap.startAutosavingMap(this.mapNameToFilename(mapName), this.cache.get(mapName));
    }

    public void saveNavigationGraph(NavigationGraphSynchronized navgraph) throws IOException {
        for (Map.Entry<String, NavigationGraphSynchronized> entry : new ArrayList<Map.Entry<String, NavigationGraphSynchronized>>(this.cache.entrySet())) {
            if (entry.getValue() == null || !((Object)((Object)entry.getValue())).equals((Object)navgraph)) continue;
            NavigationGraphProviderForMap.saveGraphToFile(this.mapNameToFilename(entry.getKey()), navgraph);
            return;
        }
        throw new IllegalArgumentException("Given navigation graph was not found in local cache map! Use appropriete method to get nav graph!");
    }

    public static void startAutosavingMap(final String filename, final NavigationGraphSynchronized g) {
        try {
            NavigationGraphProviderForMap.saveGraphToFile(filename, g);
        }
        catch (Exception ex) {
            log.error((Object)("Error while first autosaving! I give up and end! Error:" + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException("Error while first autosaving! I give up and end! Error:" + ex.getMessage(), ex);
        }
        Thread vlakno = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ex) {
                        log.info((Object)("End of saving file " + filename));
                        break;
                    }
                    try {
                        NavigationGraphProviderForMap.saveGraphToFile(filename, g);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Error while autosaving in thread! Error:" + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        });
        vlakno.setName("Saving thread for file " + filename);
        vlakno.setDaemon(true);
        vlakno.start();
    }

    public static void saveGraphToFile(String filename, NavigationGraphSynchronized g) throws IOException {
        long timeStart = System.currentTimeMillis();
        CharArrayWriter aw = new CharArrayWriter(900000);
        GraphMLWriter2<NavigationGraphSynchronized, MyVertice, MyEdge> gw = new GraphMLWriter2<NavigationGraphSynchronized, MyVertice, MyEdge>(aw, new MetadataGraphTransformer(), new MetadataNodeTransformer(), new MetadataEdgeTransformer(), null);
        long filewritingTimeStart = 0L;
        try {
            log.debug((Object)"Saving graphML file.");
            gw.writeGraph(g);
            filewritingTimeStart = System.currentTimeMillis();
            FileWriter fw = new FileWriter(filename);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(aw.toCharArray());
            bw.flush();
            try {
                bw.close();
            }
            catch (Exception ex) {
                log.error((Object)("Ignorring error on close. Error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        catch (GraphIOException ex) {
            log.error((Object)("GraphIOException error while saving graph to file. Error: " + ex.getMessage()), (Throwable)ex);
            throw new IOException("GraphIOException error while saving graph to file. Error: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            log.error((Object)("General exception while sawing graph. Error:" + ex.getMessage()), (Throwable)ex);
            throw new IOException("General exception while sawing graph. Error:" + ex.getMessage(), ex);
        }
        long timeEnd = System.currentTimeMillis();
        log.info((Object)("Gml saved to file in " + (timeEnd - timeStart) + " ms (writing to disk was " + (timeEnd - filewritingTimeStart) + "ms)."));
    }
}

