/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.score.TeamScoreChanged;

public class TeamScoreTable
implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
    private final List<TeamScoreChanged> listeners = Collections.synchronizedList(new ArrayList());
    private int redScore = -1;
    private int blueScore = -1;

    public TeamScoreTable(IWorldView worldView) {
        worldView.addEventListener(TeamScore.class, (IWorldEventListener)this);
    }

    public void addTeamScoreChangedListener(TeamScoreChanged list) {
        this.listeners.add(list);
    }

    public void removeTeamScoreChangedListener(TeamScoreChanged list) {
        this.listeners.remove(list);
    }

    public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
        TeamScore ts = (TeamScore)event.getObject();
        int team = ts.getTeam();
        switch (team) {
            case 1: {
                this.setBlueScore(ts.getScore());
                break;
            }
            case 0: {
                this.setRedScore(ts.getScore());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBlueScore(int newScore) {
        TeamScoreChanged[] listenersArray;
        if (this.blueScore == newScore) {
            return;
        }
        int oldScore = this.blueScore;
        this.blueScore = newScore;
        List<TeamScoreChanged> list = this.listeners;
        synchronized (list) {
            listenersArray = new TeamScoreChanged[this.listeners.size()];
            listenersArray = this.listeners.toArray(listenersArray);
        }
        for (TeamScoreChanged tsc : listenersArray) {
            tsc.blueScored();
            tsc.teamScoreChanged(this.redScore, this.blueScore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRedScore(int newScore) {
        TeamScoreChanged[] listenersArray;
        if (this.redScore == newScore) {
            return;
        }
        int oldScore = this.redScore;
        this.redScore = newScore;
        List<TeamScoreChanged> list = this.listeners;
        synchronized (list) {
            listenersArray = new TeamScoreChanged[this.listeners.size()];
            listenersArray = this.listeners.toArray(listenersArray);
        }
        for (TeamScoreChanged tsc : listenersArray) {
            tsc.redScored();
            tsc.teamScoreChanged(this.redScore, this.blueScore);
        }
    }
}

