/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.AbstractNotifiableCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.SelfSnapshot;

public class SelfCache
extends AbstractNotifiableCache<Self> {
    private Map<IWorldView, SelfListener> listeners = new HashMap<IWorldView, SelfListener>();
    private Map<UnrealId, List<SelfSnapshot>> selfsHistory = Collections.synchronizedMap(new HashMap());
    public static final int HISTORYSIZE = 20;

    public SelfCache(IWorldView worldView) {
        SelfListener tmp = new SelfListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(Self.class, (IWorldObjectEventListener)tmp);
    }

    @Override
    public void addAnotherViewer(IWorldView worldView) {
        SelfListener tmp = new SelfListener();
        this.listeners.put(worldView, tmp);
        worldView.addObjectListener(Self.class, (IWorldObjectEventListener)tmp);
    }

    @Override
    public void removeViewer(IWorldView worldView) {
        SelfListener tmp = this.listeners.get(worldView);
        this.listeners.remove(worldView);
        worldView.removeObjectListener(Self.class, (IWorldObjectEventListener)tmp);
    }

    public List<SelfSnapshot> getSelfHistory(UnrealId id) {
        return Collections.unmodifiableList(this.selfsHistory.get(id));
    }

    public Map<UnrealId, List<SelfSnapshot>> getSelfsHistory() {
        return Collections.unmodifiableMap(this.selfsHistory);
    }

    @Override
    protected void notify(Self event) {
        super.notify(event);
        List<SelfSnapshot> oneItemHistory = this.selfsHistory.get(event.getId());
        if (oneItemHistory == null) {
            oneItemHistory = Collections.synchronizedList(new LinkedList());
            this.selfsHistory.put(event.getId(), oneItemHistory);
        }
        oneItemHistory.add(0, new SelfSnapshot(event));
        while (oneItemHistory.size() > 20) {
            oneItemHistory.remove(20);
        }
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        private SelfListener() {
        }

        public void notify(IWorldObjectEvent<Self> event) {
            SelfCache.this.notify((Self)event.getObject());
        }
    }
}

