/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Box;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.NotifiableMap;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleFlagInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleGamerInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateAndDeleteListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.WorldProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.GamerSnapshot;

public class WorldProphetPanel
extends JPanel
implements UpdateAndDeleteListener<SimpleGamerInfo> {
    private WorldProphet worldProphet;
    SimpleFlagInfo enemyFlag = null;
    SimpleFlagInfo myFlag = null;
    NotifiableMap<SimpleGamerInfo> players = null;
    private double xScale = 1.0;
    private double xOffset = 0.0;
    private double yScale = 1.0;
    private double yOffset = 0.0;
    private boolean paintPlayers = true;
    private boolean paintFlags = true;
    private boolean paintPlayersHistory = false;

    public WorldProphetPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                WorldProphetPanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 396, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.recalculateScales();
    }

    private void paintPlayer(Graphics g, Map.Entry<UnrealId, List<GamerSnapshot>> gamer) {
        g.setColor(Color.LIGHT_GRAY);
        List<GamerSnapshot> loc = gamer.getValue();
        for (GamerSnapshot gamerHist : loc) {
            double origX = gamerHist.getLocation().x;
            double origY = gamerHist.getLocation().y;
            double x = Math.round(this.xScale * (origX + this.xOffset));
            double y = Math.round(this.yScale * (origY + this.yOffset));
            g.fillOval((int)x - 1, (int)y - 1, 3, 3);
            double age = gamerHist.getAge();
            age = (double)Math.round(age * 10.0) / 10.0;
        }
    }

    private void paintPlayer(Graphics g, SimpleGamerInfo simplePlayerInfo) {
        Set<Map.Entry<Location, Double>> loc = simplePlayerInfo.getFuzzyLocation();
        for (Map.Entry<Location, Double> entry : loc) {
            double origX = entry.getKey().x;
            double origY = entry.getKey().y;
            double x = Math.round(this.xScale * (origX + this.xOffset));
            double y = Math.round(this.yScale * (origY + this.yOffset));
            if (simplePlayerInfo.isEnemy()) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            g.fillOval((int)x - 2, (int)y - 2, 5, 5);
            g.setColor(Color.BLACK);
            g.drawString("" + entry.getValue(), (int)x, (int)y);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.isPaintPlayersHistory()) {
                HashMap<UnrealId, List<GamerSnapshot>> hist = new HashMap<UnrealId, List<GamerSnapshot>>(this.worldProphet.getGamersProphet().getGamersHistory());
                for (Map.Entry<UnrealId, List<GamerSnapshot>> entry : hist.entrySet()) {
                    this.paintPlayer(g, entry);
                }
            }
            if (this.players != null && this.isPaintPlayers()) {
                this.worldProphet.getGamersProphet().reestimateAllPlayers();
                Collection<SimpleGamerInfo> pl = this.players.getMap().values();
                for (SimpleGamerInfo simpleGamerInfo : pl) {
                    this.paintPlayer(g, simpleGamerInfo);
                }
            }
            if (this.myFlag != null && this.enemyFlag != null && this.isPaintFlags()) {
                double origX = this.myFlag.getMostProbableLocation().getKey().x;
                double d = this.myFlag.getMostProbableLocation().getKey().y;
                double x = Math.round(this.xScale * (origX + this.xOffset));
                double y = Math.round(this.yScale * (d + this.yOffset));
                g.setColor(Color.blue);
                g.drawOval((int)x - 1, (int)y - 1, 3, 3);
                g.setColor(Color.BLACK);
                g.drawString("My " + this.myFlag.getMostProbableLocation().getValue(), (int)x, (int)y);
                x = Math.round(this.xScale * (this.enemyFlag.getMostProbableLocation().getKey().x + this.xOffset));
                y = Math.round(this.yScale * (this.enemyFlag.getMostProbableLocation().getKey().y + this.yOffset));
                g.setColor(Color.red);
                g.drawOval((int)x - 1, (int)y - 1, 3, 3);
                g.setColor(Color.BLACK);
                g.drawString("Enemy " + this.enemyFlag.getMostProbableLocation().getValue(), (int)x, (int)y);
            }
        }
        catch (Exception ex) {
            System.err.println("Error while painting. Error: " + ex.getMessage() + ". Stack:");
            ex.printStackTrace();
        }
    }

    public void setWorldProphet(WorldProphet worldProphet) {
        this.unregisterProphet();
        this.worldProphet = worldProphet;
        this.registerProphet();
    }

    private void unregisterProphet() {
        if (this.worldProphet == null) {
            return;
        }
    }

    private void registerProphet() {
        this.recalculateScales();
        this.enemyFlag = this.worldProphet.getFlagsProphet().getEnemySimpleFlag();
        this.enemyFlag.addChangeListener(new UpdateListener<SimpleFlagInfo>(){

            @Override
            public void notifyOfChange(SimpleFlagInfo updatedInstance) {
                WorldProphetPanel.this.repaint();
            }
        });
        this.myFlag = this.worldProphet.getFlagsProphet().getMySimpleFlag();
        this.myFlag.addChangeListener(new UpdateListener<SimpleFlagInfo>(){

            @Override
            public void notifyOfChange(SimpleFlagInfo updatedInstance) {
                WorldProphetPanel.this.repaint();
            }
        });
        this.players = this.worldProphet.getGamersProphet().getGamers();
        this.players.addChangeListener(this);
    }

    @Override
    public void notifyOfChange(SimpleGamerInfo updatedInstance) {
        this.repaint();
    }

    @Override
    public void notifyOfDelete(SimpleGamerInfo deletedInstance) {
        this.repaint();
    }

    private void recalculateScales() {
        Box mapBox = this.worldProphet.getMapBox();
        int width = this.getWidth();
        int height = this.getHeight();
        this.xScale = (double)width / (mapBox.getDeltaX() * 1.15);
        this.yScale = (double)height / (mapBox.getDeltaY() * 1.15);
        this.xOffset = -mapBox.minX + mapBox.getDeltaX() * 0.075;
        this.yOffset = -mapBox.minY + mapBox.getDeltaY() * 0.075;
        this.repaint();
    }

    public boolean isPaintPlayers() {
        return this.paintPlayers;
    }

    public void setPaintPlayers(boolean paintPlayers) {
        this.paintPlayers = paintPlayers;
    }

    public boolean isPaintFlags() {
        return this.paintFlags;
    }

    public void setPaintFlags(boolean paintFlags) {
        this.paintFlags = paintFlags;
    }

    public boolean isPaintPlayersHistory() {
        return this.paintPlayersHistory;
    }

    public void setPaintPlayersHistory(boolean paintPlayersHistory) {
        this.paintPlayersHistory = paintPlayersHistory;
    }
}

