package jung.myalghoritm.AStar;

import java.util.List;

import javax.vecmath.Point2d;

import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import edu.uci.ics.jung.graph.Graph;

public class SimplestAStarPathPlannerForUT2004 extends SimplestAStarPathPlanner<MyVertice, MyEdge> {
	//private final MyDijkstraShortestPath<MyVertice, MyEdge> sdpp;

	public SimplestAStarPathPlannerForUT2004(Graph<MyVertice, MyEdge> navigationGraph, EdgeAndVertexToNumberWeightTransformer<MyVertice, MyEdge> transformer, Transformer<MyVertice, Point2d> transformerPositions, int implementation) {
		super(navigationGraph, transformer, transformerPositions, implementation);
		//this.sdpp = new MyDijkstraShortestPath<MyVertice, MyEdge>(navigationGraph, new EdgeAndVertexToNumberAdvancedTransformer(navigationGraph), false);
		//this.sdpp = new MyDijkstraShortestPath<MyVertice, MyEdge>(navigationGraph, new EdgeToTimeNumberTransformer(), false);
	}

	@Override
	public Double heuristicEstimateOfDistance(MyVertice a, MyVertice b) {
		//40 inch ~= 1m
		double distance = super.heuristicEstimateOfDistance(a, b)/4.0 +  + b.valueAdded;
		/*MyEdge e = this.g.findEdge(a, b);
	double additionalCost;
	if(e == null) {
	    additionalCost = getPathDuration(this.sdpp.getPath(a, b));
	} else {
	    //throw new RuntimeException("Cannot compute heuristic distance. I am not able to find edge between vertices " + a + " and " + b + ".");
	    additionalCost = e.getTravelTime();
	}
	if(Double.isNaN(additionalCost) || Double.isInfinite(additionalCost)) {
	    additionalCost = 10000;
	}
	distance += additionalCost;*/
		//System.out.println("Distance:" + distance + ", additional cost:" + additionalCost);
		return distance;
	}

	@Override
	public Double distanceBetween(MyVertice a, MyVertice b) {
		double additionalCost;
		MyEdge e = this.g.findEdge(a, b);
		if(e == null) {
			//additionalCost = getPathDuration(this.sdpp.getPath(a, b));
			throw new RuntimeException("Cannot compute direct distance. I am not able to find edge between vertices " + a + " and " + b + ". Vertices are not connected by edge!");
		} else {
			additionalCost = e.getTravelTime();
		}
		if(Double.isNaN(additionalCost) || Double.isInfinite(additionalCost)) {
			additionalCost = 10000;
		}
		return b.valueAdded + additionalCost;
	}

	public static double getPathDuration(List<MyEdge> path) {
		double navrat = 0;
		for (MyEdge myEdge : path) {
			navrat += myEdge.getTravelTime();
		}// end of foreach myEdge in path
		return navrat;
	}
}
