/**
 * 
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import java.util.Collection;

import jung.myalghoritm.MyDijkstraShortestPath;
import jung.myalghoritm.dynamicWeigths.EdgeAndVertexToNumberWeightTransformer;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToTimeNumberTransformer;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import edu.uci.ics.jung.graph.Graph;

/**
 * <p>
 * Superclass {@link InterestOfEdgesHolder} is not used by this implementation of {@link PathPlanner}. It's features are
 * used by subclasses. One example is {@link AdvancedPathPlanner}.
 * </p>
 * 
 * @author LuVar
 * 
 */
public class SimplestDijkstraPathPlanner extends UniversalPathPlanner {
	//private static final Logger log = Logger.getLogger(SimplestDijkstraPathPlanner.class);

	/**
	 * <p>
	 * This constructor use {@link EdgeToTimeNumberTransformer} transformer for transforming edges to cost of path.
	 * </p>
	 * 
	 * @param g
	 * @param bot
	 * @param navpoints
	 */
	@SuppressWarnings("unchecked")
	public SimplestDijkstraPathPlanner(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints) {
		super(g, bot, navpoints, new MyDijkstraShortestPath<MyVertice, MyEdge>(g, new EdgeToTimeNumberTransformer(), false));
	}

	/**
	 * <p>
	 * Constructor for using some simple transformer. Take into account that Dijkstra doesn't like transformers with
	 * negative outputs for edge cost!
	 * </p>
	 * 
	 * @param g
	 * @param bot used only to {@link UT2004Bot#getLocation()} when calling {@link #computePath(ILocated)} method
	 * @param navpoints used only to convert {@link ILocated} to {@link NavPoint}, because of {@link PathExecutor} and
	 *              because of vertices
	 * @param metrics something like <code>new EdgeToTimeNumberTransformer()</code> or some
	 *              {@link EdgeAndVertexToNumberWeightTransformer} class
	 */
	@SuppressWarnings("unchecked")
	public SimplestDijkstraPathPlanner(Graph<MyVertice, MyEdge> g, UT2004Bot bot, Collection<NavPoint> navpoints, Transformer<MyEdge, Number> metrics) {
		super(g, bot, navpoints, new MyDijkstraShortestPath<MyVertice, MyEdge>(g, metrics, false));
	}
}
