/*
 * GraphVisualizer.java
 *
 * Created on 16.2.2010, 12:05:39
 */
package sk.stuba.fiit.pogamut.jungigation.visualization;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.swing.JFileChooser;
import javax.swing.JFrame;

import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.layouts.Simple2DLayout;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.AdvancedPathPlanner;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToPaintTransformer;
import sk.stuba.fiit.pogamut.jungigation.transformers.EdgeToSimpleInfoStringTransformer;
import edu.uci.ics.jung.algorithms.filters.EdgePredicateFilter;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;

/**
 * 
 * @author LuVar
 */
public class GraphVisualizer extends javax.swing.JFrame {

    /** Creates new form GraphVisualizer */
    public GraphVisualizer() {
	initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

	this.jFileChooser_gml = new javax.swing.JFileChooser();
	this.menuBar = new javax.swing.JMenuBar();
	this.fileMenu = new javax.swing.JMenu();
	this.openMenuItem = new javax.swing.JMenuItem();
	this.saveMenuItem = new javax.swing.JMenuItem();
	this.saveAsMenuItem = new javax.swing.JMenuItem();
	this.exitMenuItem = new javax.swing.JMenuItem();
	this.editMenu = new javax.swing.JMenu();
	this.cutMenuItem = new javax.swing.JMenuItem();
	this.copyMenuItem = new javax.swing.JMenuItem();
	this.pasteMenuItem = new javax.swing.JMenuItem();
	this.deleteMenuItem = new javax.swing.JMenuItem();
	this.helpMenu = new javax.swing.JMenu();
	this.contentsMenuItem = new javax.swing.JMenuItem();
	this.aboutMenuItem = new javax.swing.JMenuItem();

	this.jFileChooser_gml.setCurrentDirectory(null);
	this.jFileChooser_gml.setDialogTitle("Chose which gml file to open");

	setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

	this.fileMenu.setText("File");

	this.openMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
	this.openMenuItem.setText("Open");
	this.openMenuItem.addActionListener(new java.awt.event.ActionListener() {
	    public void actionPerformed(java.awt.event.ActionEvent evt) {
		openMenuItemActionPerformed(evt);
	    }
	});
	this.fileMenu.add(this.openMenuItem);

	this.saveMenuItem.setText("Save");
	this.fileMenu.add(this.saveMenuItem);

	this.saveAsMenuItem.setText("Save As ...");
	this.fileMenu.add(this.saveAsMenuItem);

	this.exitMenuItem.setText("Exit");
	this.exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
	    public void actionPerformed(java.awt.event.ActionEvent evt) {
		exitMenuItemActionPerformed(evt);
	    }
	});
	this.fileMenu.add(this.exitMenuItem);

	this.menuBar.add(this.fileMenu);

	this.editMenu.setText("Edit");

	this.cutMenuItem.setText("Cut");
	this.editMenu.add(this.cutMenuItem);

	this.copyMenuItem.setText("Copy");
	this.editMenu.add(this.copyMenuItem);

	this.pasteMenuItem.setText("Paste");
	this.editMenu.add(this.pasteMenuItem);

	this.deleteMenuItem.setText("Delete");
	this.editMenu.add(this.deleteMenuItem);

	this.menuBar.add(this.editMenu);

	this.helpMenu.setText("Help");

	this.contentsMenuItem.setText("Contents");
	this.helpMenu.add(this.contentsMenuItem);

	this.aboutMenuItem.setText("About");
	this.helpMenu.add(this.aboutMenuItem);

	this.menuBar.add(this.helpMenu);

	setJMenuBar(this.menuBar);

	javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
	getContentPane().setLayout(layout);
	layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
	layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));

	pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_exitMenuItemActionPerformed
	System.exit(0);
    }// GEN-LAST:event_exitMenuItemActionPerformed

    @SuppressWarnings("unchecked")
    private void openMenuItemActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_openMenuItemActionPerformed
	File defolt = new File("D:\\LuVar\\eWorkspace\\Iexplorer6\\");
	this.jFileChooser_gml.setCurrentDirectory(defolt);
	int navrat = this.jFileChooser_gml.showOpenDialog(this);
	if (navrat != JFileChooser.APPROVE_OPTION) {
	    System.out.println("User abborted opening!");
	    return;
	}
	File fileToBeOpenned = this.jFileChooser_gml.getSelectedFile();

	// GmlStatistics.printInfo(fileToBeOpenned.getAbsolutePath(), "SomeMap");

	final NavigationGraphSynchronized gOriginal = new NavigationGraphProviderForMap("nothing") {
	    public NavigationGraphSynchronized getGraphFromFileMY(String filename) {
		return NavigationGraphProviderForMap.getGraphFromFile(filename);
	    }
	}.getGraphFromFileMY(fileToBeOpenned.getAbsolutePath());

	Predicate<MyEdge> predicate = new Predicate<MyEdge>() {

	    public boolean evaluate(MyEdge t) {
		if (t.getNumberOfTravelsInArray() == 0) {
		    return false;
		}
		// System.out.println(t.getNumberOfTravelsInArray());
		return true;
	    }
	};
	EdgePredicateFilter<MyVertice, MyEdge> epf = new EdgePredicateFilter<MyVertice, MyEdge>(predicate);
	int totalEdgesCount = gOriginal.getEdgeCount();
	int totalVerticesCount = gOriginal.getVertexCount();
	Graph<MyVertice, MyEdge> g = epf.transform(gOriginal);
	int filteredCount = g.getEdgeCount();
	float percentage = Math.round(((float) filteredCount / (float) totalEdgesCount) * 10000f) / 100f;
	System.out.println("Edges count ater filtering:" + filteredCount + ",beforeFiltering:" + totalEdgesCount + ". It is:" + percentage + "%.");
	// http://en.wikipedia.org/wiki/Sparse_graph
	double graphDensity;
	graphDensity = (2.0 * totalEdgesCount) / (totalVerticesCount * (totalVerticesCount - 1));
	System.out.println("Vertices: " + gOriginal.getVertexCount() + ",\t edges: " + totalEdgesCount + ",\t graphDensity: " + graphDensity);

	g = gOriginal;

	// The Layout<V, E> is parameterized by the vertex and edge types
	// SpringLayout2<MyVertice, MyEdge> layout = new SpringLayout2<MyVertice, MyEdge>(g);//CircleLayout<MyVertice,
	// MyEdge>(g);
	Simple2DLayout layout = new Simple2DLayout(g);
	layout.setSize(new Dimension(1500, 950)); // sets the initial size of the space
	// The BasicVisualizationServer<V,E> is parameterized by the edge types
	// BasicVisualizationServer<MyVertice, MyEdge> vv =
	// new BasicVisualizationServer<MyVertice, MyEdge>(layout);
	final VisualizationViewer vv = new VisualizationViewer<MyVertice, MyEdge>(layout);
	vv.setPreferredSize(new Dimension(350, 350)); // Sets the viewing area size

	vv.getRenderContext().setEdgeLabelTransformer(new EdgeToSimpleInfoStringTransformer());
	// vv.getRenderContext().setEdgeStrokeTransformer(new EdgeToStrokeTransformer());
	vv.getRenderContext().setEdgeDrawPaintTransformer(new EdgeToPaintTransformer());
	// vv.getRenderContext().setEdgeFillPaintTransformer(new EdgeToPaintTransformer());
	vv.getRenderContext().setVertexLabelTransformer(new Transformer<MyVertice, String>() {
	    public String transform(MyVertice i) {
		String aaa = i.getId().getStringId();
		aaa = aaa.substring(aaa.indexOf(".") + 1, aaa.length());
		if (aaa.toLowerCase().contains("flag")) {
		    return aaa;
		}
		if (aaa.toLowerCase().contains("inventoryspot")) {
		    return aaa;
		}
		return "";// aaa;
	    }
	});

	DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
	gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
	vv.setGraphMouse(gm);
	PickingGraphMousePlugin pgmp = new PickingGraphMousePlugin();
	gm.add(pgmp);

	// final DijkstraShortestPath<MyVertice, MyEdge> dsp = new DijkstraShortestPath<MyVertice, MyEdge>(g, new
	// EdgeToDataCountNumberTransformer());
	// final DijkstraShortestPath<MyVertice, MyEdge> dsp = new DijkstraShortestPath<MyVertice, MyEdge>(g, new
	// EdgeToTimeNumberTransformer());
	//	MyEdgeToNumberAdvancedTransformer tr = new MyEdgeToNumberAdvancedTransformer(g, MyEdgeToNumberAdvancedTransformer.getArmorInterestMapForNavpoints(g));
	// final DijkstraShortestPath<MyVertice, MyEdge> dsp = new DijkstraShortestPath<MyVertice, MyEdge>(g, tr,
	// false);
	// final FloydWarshallShortestPath dsp = new FloydWarshallShortestPath<MyVertice, MyEdge>(gOriginal, tr, false);
	//	final MyGreedyShortestPath<MyVertice, MyEdge> dsp = new MyGreedyShortestPath<MyVertice, MyEdge>(gOriginal, tr);
	final AdvancedPathPlanner dsp = new AdvancedPathPlanner(g, null, null);

	vv.addGraphMouseListener(new GraphMouseListener() {
	    public void graphClicked(Object v, MouseEvent me) {
		try {
		    Set<MyEdge> pickedE = vv.getPickedEdgeState().getPicked();
		    if (pickedE.size() == 1) {
			MyVertice mv = gOriginal.getDest(pickedE.iterator().next());
			vv.getPickedVertexState().pick(mv, true);
			return;
		    }
		} catch (Exception ex) {
		    ex.printStackTrace();
		}
		try {
		    Set<MyVertice> picked = vv.getPickedVertexState().getPicked();
		    Iterator<MyVertice> it = picked.iterator();
		    MyVertice from = it.next();
		    MyVertice to = it.next();
		    List<MyEdge> path;
		    Number length;
		    try {
			path = dsp.getPath(from, to);
			// TODO length = dsp.getDistance(from, to);
		    } catch (Exception ex) {
			System.out.println(ex.getMessage());
			ex.printStackTrace();
			throw ex;
		    }
		    // TODO System.out.println("Length of planned route is " + length.toString());
		    for (MyEdge myEdge : path) {
			vv.getPickedEdgeState().pick(myEdge, true);
		    }
		} catch (Exception ex) {
		}
	    }

	    public void graphPressed(Object v, MouseEvent me) {
		// nothing
	    }

	    public void graphReleased(Object v, MouseEvent me) {
		// nothing
	    }
	});

	JFrame frame = new JFrame("Simple Graph View");
	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	frame.getContentPane().add(vv);
	frame.pack();
	frame.setVisible(true);
    }// GEN-LAST:event_openMenuItemActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
	java.awt.EventQueue.invokeLater(new Runnable() {

	    public void run() {
		new GraphVisualizer().setVisible(true);
	    }
	});
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem aboutMenuItem;
    private javax.swing.JMenuItem contentsMenuItem;
    private javax.swing.JMenuItem copyMenuItem;
    private javax.swing.JMenuItem cutMenuItem;
    private javax.swing.JMenuItem deleteMenuItem;
    private javax.swing.JMenu editMenu;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JFileChooser jFileChooser_gml;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JMenuItem pasteMenuItem;
    private javax.swing.JMenuItem saveAsMenuItem;
    private javax.swing.JMenuItem saveMenuItem;
    // End of variables declaration//GEN-END:variables
}
