package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.AbstractMap.SimpleImmutableEntry;
import java.util.Map.Entry;

import org.apache.log4j.Logger;

import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.NotifiableMap;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleGamerInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.GamersCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.PlayersCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.SelfCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.misc.LocationValhalla;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.PlayerSnapshot;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

/**
 * <p>
 * Extract informations from {@link PlayersCache} and {@link SelfCache} instances and gives estimations of all known
 * player positions.
 * </p>
 * <p>
 * TODO implement estimation of equip, could be a problem, with cross reference to {@link ItemsProphet} instance.
 * </p>
 * 
 * @author LuVar
 * 
 * @see PlayersCache
 * @see SelfCache
 */
public class GamersProphet extends GamersCache {
    private static final Logger log = Logger.getLogger(GamersProphet.class);

    private final NotifiableMap<SimpleGamerInfo> allGamers = new NotifiableMap<SimpleGamerInfo>();
    private final NotifiableMap<SimpleGamerInfo> enemyGamers = new NotifiableMap<SimpleGamerInfo>();
    private final int team;

    public GamersProphet(IWorldView worldView, int team) {
	super(worldView);
	this.team = team;
	// this.players = worldView.getAll(Player.class).values();
    }

    public NotifiableMap<SimpleGamerInfo> getGamers() {
	return this.allGamers;
    }

    public NotifiableMap<SimpleGamerInfo> getEnemyGamers() {
	return this.enemyGamers;
    }

    @Override
    protected void notifyOfPlayerChange(Player event) {
	super.notify(event);
	Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
	SimpleGamerInfo smi = map.get(event.getId());

	List<PlayerSnapshot> history = this.getPlayerHistory(event.getId());
	boolean isEnemy = (this.team != event.getTeam());
	smi = new SimpleGamerInfo(event.getId(), GamersProphet.getEstimatedLocation(history), isEnemy, false);
	smi.setLastSeenTime(event.getSimTime());

	map.put(event.getId(), smi);
	this.allGamers.notifyOfChange(smi);

	// update also enemy map...
	if (isEnemy) {
	    this.enemyGamers.getMap().put(event.getId(), smi);
	    this.enemyGamers.notifyOfChange(smi);
	}
    }

    @Override
    protected void notifyOfSelfChange(Self event) {
	super.notify(event);
	Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
	SimpleGamerInfo smi = map.get(event.getId());

	// List<SelfSnapshoot> history = this.getSelfHistory(event.getId());
	// TODO when estimating future, this could be handy...
	boolean isEnemy = (this.team != event.getTeam());
	Set<Entry<Location, Double>> loc = new HashSet<Entry<Location, Double>>();
	loc.add(new SimpleImmutableEntry<Location, Double>(event.getLocation(), 0.99));
	smi = new SimpleGamerInfo(event.getId(), loc, isEnemy, true);
	smi.setLastSeenTime(event.getSimTime());

	map.put(event.getId(), smi);
	this.allGamers.notifyOfChange(smi);

	// update also enemy map...
	if (isEnemy) {
	    log.warn("Enemy is sending us self messages! I am team " + this.team + " and enemy team and is is " + event.getTeam() + ", " + event.getId());
	    this.enemyGamers.getMap().put(event.getId(), smi);
	    this.enemyGamers.notifyOfChange(smi);
	}
    }

    protected static Set<Entry<Location, Double>> getEstimatedLocation(List<PlayerSnapshot> history) {
	Set<Entry<Location, Double>> navrat = new HashSet<Entry<Location, Double>>();
	PlayerSnapshot last = history.get(0);
	double probability;
	Location loc;
	if (last.getLocation() instanceof LocationValhalla) {
	    probability = 0.01;
	    // TODO find spawns and give it to all spawns randomly...
	    loc = last.getLocation();
	} else {
	    probability = last.getAge();
	    if (probability < 1) {
		probability = 0.9;
	    } else {
		probability = 0.2;
		Location tip = last.getLocation().add(last.getVelocity().scale(last.getAge()));
		double tipProb = 0.2 - (last.getAge() / 100);
		tipProb = (tipProb < 0.0) ? 0.001 : tipProb;
		if (tipProb > 0.07) {
		    Entry<Location, Double> generatedPosition = new SimpleImmutableEntry<Location, Double>(tip, tipProb);
		    navrat.add(generatedPosition);
		}
	    }
	    loc = last.getLocation();
	}
	Entry<Location, Double> lastPosition = new SimpleImmutableEntry<Location, Double>(loc, probability);
	navrat.add(lastPosition);
	return navrat;
    }

    /**
     * <p>
     * Should recalculate all players estimated positions, no matter if no player data arrived. It could be used to
     * refresh probabilities of locations for players.
     * </p>
     * <p>
     * TODO optimize this and possibly autocall this method and notify about simple players change, if any.
     * </p>
     */
    public void reestimateAllPlayers() {
	Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
	for (SimpleGamerInfo gamer : map.values()) {
	    SimpleGamerInfo smi = map.get(gamer.getId());
	    boolean isSelf = gamer.isSelf();
	    boolean isEnemy = gamer.isEnemy();
	    Set<Entry<Location, Double>> loc = null;
	    if (isSelf) {
		continue;
		// No reestimation on self...
		// List<SelfSnapshoot> history = this.getSelfHistory(event.getId());
		// TODO when estimating future, this could be handy...
		// Set<Entry<Location, Double>> loc = new HashSet<Entry<Location,Double>>();
		// loc.add(new SimpleImmutableEntry<Location, Double>(smi.getMostProbableLocation().getKey(), 0.99));
	    } else {
		List<PlayerSnapshot> history = this.getPlayerHistory(gamer.getId());
		loc = GamersProphet.getEstimatedLocation(history);
	    }
	    smi = new SimpleGamerInfo(gamer.getId(), loc, isEnemy, isSelf);
	    smi.setLastSeenTime(gamer.getLastSeenTime());
	    map.put(smi.getId(), smi);
	}
    }// end of method reestimateAllPlayers
}
