/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jung.myalghoritm.MyDijkstraShortestPath;
import jung.myalghoritm.MyShortestPath;
import jung.myalghoritm.PositiveTransformer;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;

public class FewNegativeEdgesDijkstraShortestPath<V, E>
implements MyShortestPath<V, E> {
    private static final Logger log = Logger.getLogger(FewNegativeEdgesDijkstraShortestPath.class);
    private final Graph<V, E> graph;
    private final boolean cacheNegativeEdgesList;
    protected final Transformer<E, ? extends Number> transformer;
    private final int waypointsMaxCount;
    private final boolean dropSlowercomplexPathsEarly;
    private final MyDijkstraShortestPath<V, E> dijkstra;
    private List<E> negativeEdges = null;

    public FewNegativeEdgesDijkstraShortestPath(Graph<V, E> graph, Transformer<E, ? extends Number> transformer, boolean dropSlowercomplexPathsEarly) {
        this.graph = graph;
        this.transformer = transformer;
        this.cacheNegativeEdgesList = true;
        this.dijkstra = new MyDijkstraShortestPath<V, E>(graph, new PositiveTransformer<E>(transformer), this.cacheNegativeEdgesList);
        this.waypointsMaxCount = 1;
        this.dropSlowercomplexPathsEarly = dropSlowercomplexPathsEarly;
    }

    public FewNegativeEdgesDijkstraShortestPath(Graph<V, E> graph, Transformer<E, ? extends Number> transformer, boolean cacheNegativeEdgesList, boolean dropSlowercomplexPathsEarly) {
        this.graph = graph;
        this.transformer = transformer;
        this.cacheNegativeEdgesList = cacheNegativeEdgesList;
        this.dijkstra = new MyDijkstraShortestPath<V, E>(graph, new PositiveTransformer<E>(transformer), this.cacheNegativeEdgesList);
        this.waypointsMaxCount = 1;
        this.dropSlowercomplexPathsEarly = dropSlowercomplexPathsEarly;
    }

    public FewNegativeEdgesDijkstraShortestPath(Graph<V, E> graph, Transformer<E, ? extends Number> transformer, boolean cacheNegativeEdgesList, int waypointsMaxCount, boolean dropSlowercomplexPathsEarly) {
        this.graph = graph;
        this.transformer = transformer;
        this.cacheNegativeEdgesList = cacheNegativeEdgesList;
        this.dijkstra = new MyDijkstraShortestPath<V, E>(graph, new PositiveTransformer<E>(transformer), this.cacheNegativeEdgesList);
        this.waypointsMaxCount = waypointsMaxCount;
        this.dropSlowercomplexPathsEarly = dropSlowercomplexPathsEarly;
    }

    @Override
    public List<E> getPath(V source, V target) {
        if (!this.cacheNegativeEdgesList) {
            this.refreshNegativeEdgesList();
        }
        List<E> negativeEdges = this.findNegativeEdges();
        List<Object> bestPath = null;
        double bestPathCost = Double.MAX_VALUE;
        bestPath = this.getComplexPath(source, null, target);
        bestPathCost = this.getPathCost(bestPath);
        if (this.waypointsMaxCount >= 1) {
            for (E e : negativeEdges) {
                double tmpPathCost;
                List<Object> tmpPath;
                if (this.dropSlowercomplexPathsEarly) {
                    tmpPath = this.getComplexPath(source, new Object[]{e}, target, bestPathCost);
                    if (tmpPath == null) {
                        continue;
                    }
                } else {
                    tmpPath = this.getComplexPath(source, new Object[]{e}, target);
                }
                if ((tmpPathCost = this.getPathCost(tmpPath)) < bestPathCost) {
                    log.debug((Object)("Better path found through " + e + " edge."));
                    bestPath = tmpPath;
                    bestPathCost = tmpPathCost;
                }
                if (this.waypointsMaxCount < 2) continue;
                for (E f : negativeEdges) {
                    if (e.equals(f)) continue;
                    if (this.dropSlowercomplexPathsEarly) {
                        tmpPath = this.getComplexPath(source, new Object[]{e, f}, target, bestPathCost);
                        if (tmpPath == null) {
                            continue;
                        }
                    } else {
                        tmpPath = this.getComplexPath(source, new Object[]{e, f}, target);
                    }
                    if ((tmpPathCost = this.getPathCost(tmpPath)) < bestPathCost) {
                        log.debug((Object)("Better path found through " + e + " edge."));
                        bestPath = tmpPath;
                        bestPathCost = tmpPathCost;
                    }
                    if (this.waypointsMaxCount < 3) continue;
                    for (E g : negativeEdges) {
                        if (e.equals(g) || f.equals(g)) continue;
                        if (this.dropSlowercomplexPathsEarly) {
                            tmpPath = this.getComplexPath(source, new Object[]{e, f, g}, target, bestPathCost);
                            if (tmpPath == null) {
                                continue;
                            }
                        } else {
                            tmpPath = this.getComplexPath(source, new Object[]{e, f, g}, target);
                        }
                        if (!((tmpPathCost = this.getPathCost(tmpPath)) < bestPathCost)) continue;
                        log.debug((Object)("Better path found through " + e + " edge."));
                        bestPath = tmpPath;
                        bestPathCost = tmpPathCost;
                    }
                }
            }
        }
        return bestPath;
    }

    protected void getPermutations() {
    }

    public List<E> getComplexPath(V source, E[] via, V target) {
        if (via == null || via.length == 0) {
            return this.dijkstra.getPath(source, target);
        }
        Object tmpSource = source;
        Object tmpTarget = this.graph.getSource(via[0]);
        List path = this.dijkstra.getPath(tmpSource, tmpTarget);
        for (int i = 1; i < via.length - 1; ++i) {
            tmpSource = tmpTarget;
            tmpTarget = this.graph.getSource(via[i]);
            path.addAll(this.dijkstra.getPath(tmpSource, tmpTarget));
        }
        tmpSource = tmpTarget;
        tmpTarget = target;
        path.addAll(this.dijkstra.getPath(tmpSource, tmpTarget));
        return path;
    }

    public List<E> getComplexPath(V source, E[] via, V target, double max) {
        double navrat = 0.0;
        if (via == null || via.length == 0) {
            return this.dijkstra.getPath(source, target);
        }
        Object tmpSource = source;
        Object tmpTarget = this.graph.getSource(via[0]);
        List path = this.dijkstra.getPath(tmpSource, tmpTarget);
        for (Object e : path) {
            navrat += ((Number)this.transformer.transform(e)).doubleValue();
        }
        if (navrat > max) {
            return null;
        }
        for (int i = 1; i < via.length - 1; ++i) {
            tmpSource = tmpTarget;
            tmpTarget = this.graph.getSource(via[i]);
            path = this.dijkstra.getPath(tmpSource, tmpTarget);
            path.addAll(path);
            for (Object e : path) {
                navrat += ((Number)this.transformer.transform(e)).doubleValue();
            }
            if (!(navrat > max)) continue;
            return null;
        }
        tmpSource = tmpTarget;
        tmpTarget = target;
        path.addAll(this.dijkstra.getPath(tmpSource, tmpTarget));
        return path;
    }

    private void refreshNegativeEdgesList() {
        this.negativeEdges = null;
        this.findNegativeEdges();
    }

    private List<E> findNegativeEdges() {
        if (this.negativeEdges != null) {
            return this.negativeEdges;
        }
        log.debug((Object)"Going to find negative edges.");
        Collection edges = this.graph.getEdges();
        this.negativeEdges = new ArrayList();
        for (Object e : edges) {
            Number n = (Number)this.transformer.transform(e);
            if (!(n.doubleValue() < 0.0)) continue;
            this.negativeEdges.add(e);
        }
        log.debug((Object)("Found " + this.negativeEdges.size() + " negative edges."));
        return this.negativeEdges;
    }

    public double getPathCost(List<E> path) {
        double navrat = 0.0;
        for (E e : path) {
            navrat += ((Number)this.transformer.transform(e)).doubleValue();
        }
        return navrat;
    }

    public String toString() {
        return super.toString() + "-" + this.dropSlowercomplexPathsEarly + "-" + this.waypointsMaxCount;
    }
}

