/*
 * Decompiled with CFR 0.152.
 */
package jung.myalghoritm.dynamicWeigths;

import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.TransformerChangeable;

public class EdgeAndVertexToNumberWeightTransformer<V, E>
extends TransformerChangeable<E, Number> {
    protected Transformer<V, Number> currentTransformerInterestForVertex;
    protected final Graph<V, E> navigationGraph;

    public EdgeAndVertexToNumberWeightTransformer(Graph<V, E> navigationGraph, Transformer<V, Number> transformerVertexInterest, Transformer<E, Number> transformerEdgesInterest) {
        super(transformerEdgesInterest);
        this.navigationGraph = navigationGraph;
        this.currentTransformerInterestForVertex = transformerVertexInterest;
    }

    @Override
    public final Number transform(E edge) {
        Number edgePrice = (Number)super.transform(edge);
        Number verticePrice = (Number)this.currentTransformerInterestForVertex.transform(this.navigationGraph.getDest(edge));
        return this.transformMerge(edgePrice, verticePrice);
    }

    protected Number transformMerge(Number edgePrice, Number verticePrice) {
        return edgePrice.doubleValue() + verticePrice.doubleValue();
    }

    public final void setCurrentTransformerInterestForVertex(Transformer<V, Number> currentTransformerInterestForVertex) {
        this.currentTransformerInterestForVertex = currentTransformerInterestForVertex;
    }

    public final void setCurrentTransformerInterestForEdge(Transformer<E, Number> currentTransformerInterestForEdge) {
        this.setCurrentTransformer(currentTransformerInterestForEdge);
    }

    public final Transformer<V, Number> getCurrentTransformerInterestForVertex() {
        return this.currentTransformerInterestForVertex;
    }

    public final Transformer<E, Number> getCurrentTransformerInterestForEdge() {
        return this.getCurrentTransformer();
    }
}

